/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web.view;

import cn.ymotel.dactor.async.web.view.HttpView;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.message.ServletMessage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreeMakerView
implements HttpView {
    private String ContentType;
    private static final Log logger = LogFactory.getLog(FreeMakerView.class);
    private String suffix;
    private String path;
    private String prefix;
    private Configuration freeMarkerConfig;

    public String getContentType() {
        return this.ContentType;
    }

    public void setContentType(String contentType) {
        this.ContentType = contentType;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Configuration getFreeMarkerConfig() {
        return this.freeMarkerConfig;
    }

    public void setFreeMarkerConfig(Configuration freeMarkerConfig) {
        this.freeMarkerConfig = freeMarkerConfig;
    }

    @Override
    public void render(Message message, String viewName) {
        try {
            if (!(message instanceof ServletMessage)) {
                return;
            }
            ServletMessage lMessage = (ServletMessage)message;
            if (lMessage.getAsyncContext().getResponse().isCommitted()) {
                return;
            }
            if (this.getContentType() != null) {
                lMessage.getAsyncContext().getResponse().setContentType(this.getContentType());
            }
            String tplpath = null;
            tplpath = this.path != null ? this.prefix + this.path + this.suffix : this.prefix + viewName + this.suffix;
            Template t = this.freeMarkerConfig.getTemplate(tplpath);
            StringWriter writer = new StringWriter();
            t.process((Object)message.getContext(), (Writer)writer);
            String sss = this.ProcessAfter(message, writer);
            lMessage.getAsyncContext().getResponse().getWriter().print(sss);
            lMessage.getAsyncContext().getResponse().getWriter().flush();
            try {
                lMessage.getAsyncContext().complete();
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"renderInner(LocalServletMessage, String)");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"render(Message, String)");
            }
        }
        catch (TemplateException e) {
            e.printStackTrace();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"render(Message, String)");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String ProcessAfter(Message message, StringWriter writer) {
        return writer.toString();
    }
}

