/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web;

import cn.ymotel.dactor.async.web.DActorAsyncListener;
import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.core.disruptor.MessageRingBufferDispatcher;
import cn.ymotel.dactor.message.DefaultResolveMessage;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.spring.SpringUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.util.UrlPathHelper;

public class AsyncServlet
extends FrameworkServlet {
    private static final Log logger = LogFactory.getLog(AsyncServlet.class);
    private long timeout = 900000L;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private DefaultResolveMessage defaultResolveMessage;
    private String messageSourceId = "messageSource";
    private int errorcode = 429;
    private static final String DISPATCHER = WebApplicationContext.class.getName() + ".dispatchers";

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageSource messageSource = (MessageSource)SpringUtils.getCacheBean((ApplicationContext)this.getWebApplicationContext(), this.messageSourceId);
        JstlUtils.exposeLocalizationContext((HttpServletRequest)request, (MessageSource)messageSource);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("doService(HttpServletRequest, HttpServletResponse) - contenttype----" + request.getContentType()));
        }
        Enumeration enum1 = request.getHeaderNames();
        while (enum1.hasMoreElements()) {
            String el = enum1.nextElement().toString();
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("doService(HttpServletRequest, HttpServletResponse) - el----" + el + "----" + request.getHeader(el)));
        }
        String UrlPath = this.urlPathHelper.getLookupPathForRequest(request);
        String suffix = UrlPath.substring(UrlPath.lastIndexOf(".") + 1);
        String transactionId = AsyncServlet.resolveTransactionId(UrlPath, request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doService(HttpServletRequest, HttpServletResponse) - suffix-----" + suffix + "--transactionId--" + transactionId));
        }
        if ((transactionId = SpringUtils.getBeanFromTranstionId((ApplicationContext)this.getWebApplicationContext(), transactionId)) == null) {
            response.getOutputStream().flush();
            return;
        }
        ActorTransactionCfg cfg = (ActorTransactionCfg)SpringUtils.getCacheBean((ApplicationContext)this.getWebApplicationContext(), transactionId);
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.addListener((AsyncListener)new DActorAsyncListener());
        asyncContext.setTimeout(this.timeout);
        Message message = this.defaultResolveMessage.resolveContext(asyncContext, request, response);
        Map params = this.getUrlmap(UrlPath, cfg, request);
        message.getContext().putAll(params);
        message.getContext().put("_METHOD", request.getMethod());
        message.getContext().put("_SUFFIX", suffix);
        try {
            boolean b = this.getDispatcher(request.getServletContext()).startMessage(message, cfg, false);
            if (!b) {
                ((HttpServletResponse)asyncContext.getResponse()).sendError(this.errorcode);
                return;
            }
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"doService(HttpServletRequest, HttpServletResponse)");
            }
            asyncContext.getResponse().setContentType("text/html; charset=utf-8");
            asyncContext.getRequest().setAttribute("_EXCEPTION", (Object)e);
            asyncContext.getResponse().getWriter().print(e.getMessage());
            asyncContext.getResponse().getWriter().flush();
            asyncContext.complete();
        }
    }

    public Map getUrlmap(String urlPath, ActorTransactionCfg cfg, HttpServletRequest request) {
        if (cfg.getUrlPattern() == null) {
            return new HashMap();
        }
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (urlPath.indexOf("/") < 0) {
            return new HashMap();
        }
        int end = urlPath.lastIndexOf(".");
        if (end >= 0) {
            urlPath = urlPath.substring(0, end);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] urlPaths = urlPath.split("/");
        String[] tmps = cfg.getUrlPattern();
        int len = 0;
        len = tmps.length > urlPaths.length ? urlPaths.length : tmps.length;
        for (int i = 0; i < len; ++i) {
            String value = AsyncServlet.getUrlName(tmps[i]);
            if (value == null) continue;
            map.put(value, urlPaths[i]);
        }
        return map;
    }

    public static String getUrlName(String value) {
        if (value.indexOf("{") < 0) {
            return null;
        }
        return value.substring(value.indexOf("{") + 1, value.indexOf("}"));
    }

    public static void main(String[] args) {
        String s = "/olview.view/a.do";
        System.out.println(AsyncServlet.resolveTransactionId(s, null));
    }

    protected static String resolveTransactionId(String path, HttpServletRequest request) {
        if (path.startsWith("/")) {
            return path.substring(1, path.lastIndexOf(".")).replaceAll("/", ".");
        }
        return path.substring(0, path.lastIndexOf(".")).replaceAll("/", ".");
    }

    public MessageRingBufferDispatcher getDispatcher(ServletContext sc) {
        if (sc.getAttribute(DISPATCHER) != null) {
            return (MessageRingBufferDispatcher)sc.getAttribute(DISPATCHER);
        }
        MessageRingBufferDispatcher dispatcher = (MessageRingBufferDispatcher)SpringUtils.getCacheBean((ApplicationContext)this.getWebApplicationContext(), "MessageRingBufferDispatcher");
        sc.setAttribute(DISPATCHER, (Object)dispatcher);
        return dispatcher;
    }

    public void init(ServletConfig config) throws ServletException {
        this.setApplicationContext((ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)config.getServletContext()));
        super.init(config);
        String serrcode = config.getInitParameter("errcode");
        if (serrcode != null && !serrcode.trim().equals("")) {
            try {
                this.errorcode = Integer.parseInt(serrcode);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.urlPathHelper.setAlwaysUseFullPath(true);
        this.defaultResolveMessage = (DefaultResolveMessage)SpringUtils.getCacheBean((ApplicationContext)this.getWebApplicationContext(), "DefaultResolveMessage");
    }
}

