/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.netty.httpserver;

import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.core.disruptor.MessageRingBufferDispatcher;
import cn.ymotel.dactor.message.DefaultMessage;
import cn.ymotel.dactor.message.Message;
import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ChannelHandler.Sharable
public class NettyHttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements ApplicationContextAware {
    private MessageRingBufferDispatcher MessageDispatcher;
    private ApplicationContext applicationContext;

    public MessageRingBufferDispatcher getMessageDispatcher() {
        return this.MessageDispatcher;
    }

    public void setMessageDispatcher(MessageRingBufferDispatcher messageDispatcher) {
        this.MessageDispatcher = messageDispatcher;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) throws Exception {
        String transactionId = this.getTransactionId(fullHttpRequest.uri());
        DefaultMessage message = new DefaultMessage();
        Map params = this.getParams(fullHttpRequest);
        if (params != null) {
            message.getContext().putAll(params);
        }
        message.getControlData().put("_ChannelHandlerContext", channelHandlerContext);
        message.getControlData().put("transport", "http");
        if (this.applicationContext == null) {
            channelHandlerContext.writeAndFlush((Object)this.responseOK(HttpResponseStatus.OK, "")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        if (!this.applicationContext.containsBean(transactionId)) {
            channelHandlerContext.writeAndFlush((Object)this.responseOK(HttpResponseStatus.OK, "")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ActorTransactionCfg cfg = (ActorTransactionCfg)this.applicationContext.getBean(transactionId);
        boolean b = this.getMessageDispatcher().startMessage((Message)message, cfg, false);
        if (!b) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TOO_MANY_REQUESTS);
            channelHandlerContext.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public String getTransactionId(String url) {
        return url.substring(1, url.lastIndexOf("."));
    }

    public Map getParams(FullHttpRequest fullHttpRequest) {
        if (fullHttpRequest.method() == HttpMethod.GET) {
            return this.getGetParamsFromChannel(fullHttpRequest);
        }
        if (fullHttpRequest.method() == HttpMethod.POST) {
            return this.getPostParamsFromChannel(fullHttpRequest);
        }
        return null;
    }

    private Map<String, Object> getGetParamsFromChannel(FullHttpRequest fullHttpRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fullHttpRequest.method() == HttpMethod.GET) {
            QueryStringDecoder decoder = new QueryStringDecoder(fullHttpRequest.uri());
            Map paramList = decoder.parameters();
            for (Map.Entry entry : paramList.entrySet()) {
                params.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
            }
            return params;
        }
        return null;
    }

    private Map<String, Object> getPostParamsFromChannel(FullHttpRequest fullHttpRequest) {
        Map<Object, Object> params = new HashMap();
        if (fullHttpRequest.method() == HttpMethod.POST) {
            String strContentType = fullHttpRequest.headers().get("Content-Type").trim();
            if (strContentType.contains("x-www-form-urlencoded")) {
                params = this.getFormParams(fullHttpRequest);
            } else if (strContentType.contains("application/json")) {
                try {
                    params = this.getJSONParams(fullHttpRequest);
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            } else {
                return null;
            }
            return params;
        }
        return null;
    }

    private Map<String, Object> getFormParams(FullHttpRequest fullHttpRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(false), (HttpRequest)fullHttpRequest);
        List postData = decoder.getBodyHttpDatas();
        for (InterfaceHttpData data : postData) {
            if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            MemoryAttribute attribute = (MemoryAttribute)data;
            params.put(attribute.getName(), attribute.getValue());
        }
        return params;
    }

    private Map<String, Object> getJSONParams(FullHttpRequest fullHttpRequest) throws UnsupportedEncodingException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ByteBuf content = fullHttpRequest.content();
        byte[] reqContent = new byte[content.readableBytes()];
        content.readBytes(reqContent);
        String strContent = new String(reqContent, "UTF-8");
        Map jsonParams = (Map)JSON.parse((String)strContent);
        for (Object key : jsonParams.keySet()) {
            params.put(key.toString(), jsonParams.get(key));
        }
        return params;
    }

    private FullHttpResponse responseOK(HttpResponseStatus status, String content) {
        ByteBuf byteBufcontent = Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, byteBufcontent);
        if (content != null) {
            response.headers().set("Content-Type", (Object)"application/json;charset=UTF-8");
            response.headers().set("Content_Length", (Object)response.content().readableBytes());
        }
        return response;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

