/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.netty.httpserver;

import cn.ymotel.dactor.action.AbstractJsonSupportActor;
import cn.ymotel.dactor.exception.DActorException;
import cn.ymotel.dactor.message.Message;
import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class HttpServerResponseActor
extends AbstractJsonSupportActor {
    @Override
    public Object Execute(Message message) throws Exception {
        ChannelHandlerContext ctx = (ChannelHandlerContext)message.getControlData().get("_ChannelHandlerContext");
        Map obj = null;
        obj = message.getContext().get("_Content") != null ? (Map)message.getContext().get("_Content") : message.getContext();
        HashMap<String, Map> rtnMap = new HashMap<String, Map>();
        HashMap<String, String> head = new HashMap<String, String>();
        rtnMap.put("head", head);
        if (message.getException() == null) {
            head.put("errcode", "0");
            head.put("errmsg", "\u6210\u529f");
        } else if (message.getException() instanceof DActorException) {
            DActorException ex = (DActorException)message.getException();
            head.put("errcode", ex.getErrorCode());
            head.put("errmsg", ex.getMessage());
        } else {
            head.put("errcode", "10000");
            head.put("errmsg", message.getException().getMessage());
        }
        rtnMap.put("body", obj);
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)(JSON.toJSON(rtnMap) + ""), (Charset)CharsetUtil.UTF_8);
        FullHttpResponse response = null;
        response = this.responseOK(HttpResponseStatus.OK, content);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return message;
    }

    private FullHttpResponse responseOK(HttpResponseStatus status, ByteBuf content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        if (content != null) {
            response.headers().set("Content-Type", (Object)"text/plain;charset=UTF-8");
            response.headers().set("Content_Length", (Object)response.content().readableBytes());
        }
        return response;
    }
}

