/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.netty.aysnsocket;

import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.core.disruptor.MessageRingBufferDispatcher;
import cn.ymotel.dactor.message.DefaultMessage;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.spring.SpringUtils;
import com.alibaba.fastjson.JSON;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ChannelHandler.Sharable
public class TcpServerHandler
extends SimpleChannelInboundHandler
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(TcpServerHandler.class);
    private MessageRingBufferDispatcher MessageDispatcher;
    private ApplicationContext applicationContext;

    public MessageRingBufferDispatcher getMessageDispatcher() {
        return this.MessageDispatcher;
    }

    public void setMessageDispatcher(MessageRingBufferDispatcher messageDispatcher) {
        this.MessageDispatcher = messageDispatcher;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        DefaultMessage message = new DefaultMessage();
        Map data = (Map)JSON.parse((String)((String)msg));
        message.getContext().putAll(data);
        message.getControlData().put("_ChannelHandlerContext", ctx);
        String transactionId = (String)data.get("actorId");
        ActorTransactionCfg cfg = (ActorTransactionCfg)SpringUtils.getCacheBean(this.applicationContext, transactionId);
        this.getMessageDispatcher().startMessage((Message)message, cfg, false);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("exceptionCaught(ChannelHandlerContext, Throwable) - " + cause));
        }
        ctx.close();
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.applicationContext = arg0;
    }
}

