/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.httpclient;

import cn.ymotel.dactor.action.httpclient.IdleConnectionEvictor;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.InitializingBean;

public class HttpClientHelper
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(HttpClientHelper.class);
    private CloseableHttpAsyncClient httpclient;
    private int maxTotal = 100;
    private IdleConnectionEvictor connEvictor;

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public CloseableHttpAsyncClient getHttpclient() {
        return this.httpclient;
    }

    public void shutdown() {
        block2: {
            this.connEvictor.shutdown();
            try {
                this.httpclient.close();
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace((Object)"shutdown()");
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
        PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        cm.setMaxTotal(this.maxTotal);
        cm.setDefaultMaxPerRoute(this.maxTotal);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterPropertiesSet() - " + cm.getDefaultConnectionConfig()));
        }
        CookieSpecProvider easySpecProvider = new CookieSpecProvider(){

            public CookieSpec create(HttpContext context) {
                return new BrowserCompatSpec(){

                    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                    }
                };
            }
        };
        Registry reg = RegistryBuilder.create().register("best-match", (Object)new BestMatchSpecFactory()).register("compatibility", (Object)new BrowserCompatSpecFactory()).register("mySpec", (Object)easySpecProvider).build();
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("mySpec").build();
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setDefaultCookieSpecRegistry((Lookup)reg).setDefaultRequestConfig(requestConfig).setConnectionManager((NHttpClientConnectionManager)cm).setSSLStrategy((SchemeIOSessionStrategy)SSLIOSessionStrategy.getDefaultStrategy());
        this.httpclient = builder.build();
        this.httpclient.start();
        this.connEvictor = new IdleConnectionEvictor((NHttpClientConnectionManager)cm);
        this.connEvictor.start();
    }
}

