/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action;

import cn.ymotel.dactor.action.Actor;
import cn.ymotel.dactor.async.web.view.StreamView;
import cn.ymotel.dactor.exception.DActorException;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.message.ServletMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonViewResolverActor
implements Actor {
    private static final Log logger = LogFactory.getLog(JsonViewResolverActor.class);
    Map<String, StreamView> viewMap = new HashMap<String, StreamView>();

    public Map<String, StreamView> getViewMap() {
        return this.viewMap;
    }

    public void setViewMap(Map viewMap) {
        this.viewMap = viewMap;
    }

    @Override
    public Object HandleMessage(Message message) throws Exception {
        block14: {
            if (message instanceof ServletMessage) {
                Map dataMap = message.getContext();
                for (Map.Entry entry : dataMap.entrySet()) {
                    ((ServletMessage)message).getAsyncContext().getRequest().setAttribute((String)entry.getKey(), entry.getValue());
                }
                if (message.getException() != null) {
                    ((ServletMessage)message).getAsyncContext().getRequest().setAttribute("_EXCEPTION", (Object)message.getException());
                }
            }
            StreamView view = this.getViewMap().get("default");
            Object jsonObject = message.getContext().get(view.getContent());
            if (jsonObject == null) {
                jsonObject = new HashMap();
                message.getContext().put(view.getContent(), jsonObject);
            }
            if (jsonObject instanceof Map) {
                Map rtnMap = (Map)jsonObject;
                if (!rtnMap.containsKey("errcode")) {
                    if (message.getException() == null) {
                        rtnMap.put("errcode", "0");
                        rtnMap.put("errmsg", "\u6210\u529f");
                    } else if (message.getException() instanceof DActorException) {
                        DActorException ex = (DActorException)message.getException();
                        rtnMap.put("errcode", ex.getErrorCode());
                        rtnMap.put("errmsg", ex.getMessage());
                    } else {
                        rtnMap.put("errcode", "10000");
                        rtnMap.put("errmsg", message.getException().getMessage());
                    }
                }
                if (message.getException() != null && logger.isTraceEnabled()) {
                    logger.trace((Object)"HandleMessage(Message)");
                }
            }
            try {
                view.render(message, "");
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("HandleMessage(Message) - viewResolver-----" + (ServletMessage)message + "----" + ((ServletMessage)message).getAsyncContext()));
                }
                if (!logger.isTraceEnabled()) break block14;
                logger.trace((Object)"HandleMessage(Message)");
            }
        }
        return message;
    }
}

