package Main.runner;

import Main.Tools.PrintColor;
import Main.mxgateHelper;
import cn.ymatrix.utils.StrUtil;

import java.util.ArrayList;

public class E2ECaseRunner {
    private final String TAG = StrUtil.logTagWrap(this.getClass().getName());

    final Main.mxgateHelper mxgateHelper = getMxgateHelper();
    private static ArrayList<E2ECase> e2ECases = new ArrayList<>();

    private static E2ECaseRunner runner = new E2ECaseRunner();

    E2ECaseRunner() {
    }

    private mxgateHelper getMxgateHelper() {
        mxgateHelper h = null;
        try {
            h = new mxgateHelper();
        } catch (Exception e) {
            PrintColor.RedPrint(String.format("failed to init mxgate helper: %s", e.getMessage()));
            System.exit(1);
        }

        return h;
    }

    public static E2ECaseRunner getInstance() {
        return runner;
    }

    void addTestCase(E2ECase t) {
        e2ECases.add(t);
    }

    void execute() {
        int successCnt = 0;
        int failedCnt = 0;
        for (E2ECase t : e2ECases) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
            }

            mxgateHelper.foreStop();
            try {
                PrintColor.BluePrint(String.format("Ready to execute: %s", t.getName()));
                t.execute();
                successCnt++;
            } catch (AssertionError | Exception e) {
                failedCnt++;
                PrintColor.RedPrint(String.format("[%s] failed to execute: %s", t.getName(), e.getMessage()));
                e.printStackTrace();
            }
            mxgateHelper.foreStop();
        }

        int allCnt = e2ECases.size();
        int remain = allCnt - successCnt - failedCnt;
        if (failedCnt > 0 || remain > 0) {
            System.out.println(TAG+" -- "+PrintColor.ANSI_RED+"FAILED"+PrintColor.ANSI_RESET
                    +" | "+PrintColor.ANSI_BLUE+"Total: "+allCnt+PrintColor.ANSI_RESET
                    +" | "+PrintColor.ANSI_GREEN+"Success: "+successCnt+PrintColor.ANSI_RESET
                    +" | "+PrintColor.ANSI_RED+"Failed: "+failedCnt+PrintColor.ANSI_RESET
                    +" | "+PrintColor.ANSI_YELLOW+"Remain: "+remain+PrintColor.ANSI_RESET);
            System.exit(1);
        } else {
            System.out.println(TAG+" -- "+PrintColor.ANSI_GREEN+"PASS"+PrintColor.ANSI_RESET
                    +" | "+PrintColor.ANSI_BLUE+"Total: "+allCnt+PrintColor.ANSI_RESET
                    +" | "+PrintColor.ANSI_GREEN+"Success: "+successCnt+PrintColor.ANSI_RESET);
        }

        System.exit(0);
    }
}
