package Main.cases.grpc;

import Main.LockFiles;
import Main.cases.DBHelper;
import Main.runner.E2ECase;
import cn.ymatrix.apiclient.MxClient;
import cn.ymatrix.builder.MxBuilder;
import cn.ymatrix.logger.MxLogger;
import org.junit.Assert;
import org.slf4j.Logger;

import static org.junit.Assert.assertTrue;

public class WriterIsNilGRPC implements E2ECase  {

    private static final Logger l = MxLogger.init(WriterIsNilGRPC.class);
    private final Main.mxgateHelper mxgateHelper;
    private final DBHelper dbHelper = new DBHelper();
    private final MxBuilder builder;

    public WriterIsNilGRPC(MxBuilder builder, Main.mxgateHelper helper) {
        this.mxgateHelper = helper;
        this.builder = builder;
    }

    @Override
    public void execute() throws Exception {
        String schema = "public";
        String tableName1 = String.format("%s_table_0001", this.getClass().getSimpleName()).toLowerCase();
        dbHelper.createTable(String.format("CREATE TABLE IF NOT EXISTS %1$s.%2$s (c1 INT NOT NULL, c2 INT NOT NULL, c3 text); TRUNCATE %1$s.%2$s", schema, tableName1));

        String configStr = String.format("[source]\n" +
                "\tsource = \"grpc\"\n" +
                "\t[source.grpc]\n" +
                "\t\tmax-request-bytes = 3000000\n" +
                "\t\trequest-timeout = 1000\n" +
                "[transform]\n" +
                "\ttransform = \"plain\"\n" +
                "[job]\n" +
                "\tallow-dynamic = true\n" +
                "\tdelimiter = \"|\"\n" +
                "\tformat = \"csv\"\n" +
                "\ttime-format = \"raw\"\n" +
                "\t[[job.target]]\n" +
                "\t\tdelimiter = \"|\"\n" +
                "\t\tformat = \"csv\"\n" +
                "\t\tname = \"%1$s.%2$s\"\n" +
                "\t\tschema = \"%1$s\"\n" +
                "\t\ttable = \"%2$s\"\n" +
                "[writer]\n" +
                "\twriter = \"nil\"\n" +
                "[misc]\n" +
                "\tdebug = true\n", schema, tableName1);

        mxgateHelper.startWithConfig(dbHelper.getDBName(), configStr);
        int grpcPort = new LockFiles().getOneGrpcPort();

        String cfgStr = mxgateHelper.getConfig();
        assertTrue("should get mxgate config",cfgStr != null && cfgStr.length() > 0 );

        String grpcURL = String.format("localhost:%d", grpcPort);

        MxClient client = this.builder.connect(grpcURL, grpcURL, schema, tableName1);
        Assert.assertNotNull(client);
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }


}
