package Main.cases.grpc;

import Main.LockFiles;
import Main.TestLogger;
import Main.cases.DBHelper;
import Main.cases.DataUtils;
import Main.mxgateHelper;
import Main.runner.E2ECase;
import cn.ymatrix.apiclient.MxClient;
import cn.ymatrix.builder.ConnectionListener;
import cn.ymatrix.builder.MxBuilder;
import junit.framework.AssertionFailedError;
import org.slf4j.Logger;

import java.io.IOException;
import java.sql.SQLException;

import static org.junit.Assert.*;

public class ExceptedFailureGRPC implements E2ECase {
    private final Logger l = TestLogger.init(this.getClass());

    private final Main.mxgateHelper mxgateHelper;
    final static DBHelper dbHelper = new DBHelper();
    private final DataUtils dataMaker = new DataUtils();

    final private MxBuilder builder;
    private int grpcPort;

    public ExceptedFailureGRPC(MxBuilder builder, mxgateHelper mxgateHelper) {
        this.mxgateHelper = mxgateHelper;
        this.builder = builder;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
    @Override
    public void execute() throws AssertionError, IOException, SQLException {
        String schema = "public";
        String tableName = String.format("%s_table_0001", this.getClass().getSimpleName()).toLowerCase();

        // prepare
        dbHelper.createTable(String.format("CREATE TABLE IF NOT EXISTS %1$s.%2$s (time TIMESTAMP, tagid INT, c1 INT NOT NULL, c2 INT NOT NULL DEFAULT 0, c3 text) DISTRIBUTED BY (tagid);TRUNCATE %1$s.%2$s", schema, tableName));

        // start mxgate
        String configStr = String.format("[source]\n" +
                "\tsource = \"grpc\"\n" +
                "\t[source.grpc]\n" +
                "\t\tmax-request-bytes = 3000000\n" +
                "\t\trequest-timeout = 500\n" +
                "[transform]\n" +
                "\ttransform = \"plain\"\n" +
                "[job]\n" +
                "\tallow-dynamic = true\n" +
                "\tdelimiter = \"|\"\n" +
                "\tformat = \"csv\"\n" +
                "\ttime-format = \"unix-ms\"\n" +
                "\t[[job.target]]\n" +
                "\t\tdelimiter = \"|\"\n" +
                "\t\tformat = \"csv\"\n" +
                "\t\tname = \"%1$s.%2$s\"\n" +
                "\t\tschema = \"%1$s\"\n" +
                "\t\ttable = \"%2$s\"\n" +
                "[writer]\n" +
                "\twriter = \"stream\"\n" +
                "[misc]\n" +
                "\tdebug = true\n", schema, tableName);

        System.out.println(configStr);
        mxgateHelper.startWithConfig(dbHelper.getDBName(), configStr);
        this.grpcPort = new LockFiles().getOneGrpcPort();

        String cfgStr = mxgateHelper.getConfig();
        assertTrue("should get mxgate config",cfgStr != null && cfgStr.length() > 0 );

        // call sdk
        String grpcURL = String.format("localhost:%d", this.grpcPort);
        // should failed: (1) wrong format (2) out of range (3) violate constraint (4) column not found
        builder.connect(grpcURL, grpcURL, schema, tableName, new ConnectionListener() {
            @Override
            public void onFailure(String failureMsg) {
                throw new AssertionFailedError(String.format("failed to connect to {}: {}", tableName, failureMsg));
            }

            @Override
            public void onSuccess(MxClient client) {
                l.info("Get MxClient success, begin to send data to {}.");

                dataMaker.sendFailedWrongType1(client);
            }
        });

        builder.connect(grpcURL, grpcURL, schema, tableName, new ConnectionListener() {
            @Override
            public void onFailure(String failureMsg) {
                throw new AssertionFailedError(String.format("failed to connect to {}: {}", tableName, failureMsg));
            }

            @Override
            public void onSuccess(MxClient client) {
                l.info("Get MxClient success, begin to send data to {}.");

                dataMaker.sendFailedOutOfRange1(client);
            }
        });

        builder.connect(grpcURL, grpcURL, schema, tableName, new ConnectionListener() {
            @Override
            public void onFailure(String failureMsg) {
                throw new AssertionFailedError(String.format("failed to connect to {}: {}", tableName, failureMsg));
            }

            @Override
            public void onSuccess(MxClient client) {
                l.info("Get MxClient success, begin to send data to {}.");

                dataMaker.sendFailedShouldNotNull1(client);
            }
        });

        builder.connect(grpcURL, grpcURL, schema, tableName, new ConnectionListener() {
            @Override
            public void onFailure(String failureMsg) {
                throw new AssertionFailedError(String.format("failed to connect to {}: {}", tableName, failureMsg));
            }

            @Override
            public void onSuccess(MxClient client) {
                l.info("Get MxClient success, begin to send data to {}.");

                dataMaker.sendFailedColumnNotFound1(client);
            }
        });

        dataMaker.waitProcess();
        try {
            assertEquals(String.format("should count 0 in %s.%s", schema, tableName), 0, dbHelper.countTuple(tableName));
        } catch (SQLException e) {
            throw new AssertionFailedError(String.format("should not catch SQLException when counting tuples: %s", e.getMessage()));
        } catch (AssertionError e) {
            throw e;
        }
    }
}
