package Main;

import Main.Tools.CmdExecutor;
import org.slf4j.Logger;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;

public class mxgateHelper {
    private final Logger l = TestLogger.init(mxgateHelper.class);

    private final static String mxgatePath;
    static {
        mxgatePath = new FindExecutable().lookPath("mxgate");
    }

    public mxgateHelper() throws FileNotFoundException {
        if (mxgatePath == null) {
            throw new FileNotFoundException("mxgate not found in PATH");
        }
    }

    public String gateExec(String name, ArrayList<String> args, BufferedReader stdin, String config) throws IOException {
        if (config != null && config.length() > 0) {
            try {
                File tempFile = File.createTempFile("mxgate_config_", ".conf");
                tempFile.deleteOnExit();

                FileWriter fWriter = new FileWriter(tempFile);
                fWriter.write(config);
                fWriter.close();

                args.add("--config");
                args.add(tempFile.getAbsolutePath());
            } catch (Exception e) {
                l.error("make temp file for mxgate config failed: {}", e.getMessage());
                throw e;
            }
        }

        args.add(0, mxgatePath);
        return CmdExecutor.run("mxgate"+"-"+name, args, stdin, 200, 50);
    }

    public String start(final String dbName) throws IOException {
        return gateExec("start", new ArrayList<>(Arrays.asList(new String[]{
                "start",
                "--db-database", dbName,
                "--db-master-port", System.getenv().getOrDefault("PGPORT", "5432"),
                "--db-master-host", "localhost"})), null, "");
    }

    public String startWithConfig(final String dbName, final String configStr) throws IOException {
        return gateExec("start", new ArrayList<>(Arrays.asList(new String[]{
                "start",
                "--db-database", dbName,
                "--db-master-port", System.getenv().getOrDefault("PGPORT", "5432"),
                "--db-master-host", "localhost"})), null, configStr);
    }

    public void foreStop() {
        try {
            gateExec("force stop", new ArrayList<>(Arrays.asList(new String[]{
                    "stop",
                    "-f"})), null, null);
        } catch (Exception e) {
            l.warn("failed to stop mxgate: {}", e.getMessage());
        }
    }

    public String getConfig() throws IOException {
        return gateExec("get mxgate config", new ArrayList<>(Arrays.asList(new String[]{
                "get",
                "--current-config"})), null, null);
    }
}
