package Main.cases.http;

import Main.LockFiles;
import Main.TestLogger;
import Main.cases.DBHelper;
import Main.cases.DataUtils;
import Main.runner.E2ECase;
import cn.ymatrix.apiclient.MxClient;
import cn.ymatrix.builder.ConnectionListener;
import cn.ymatrix.builder.MxBuilder;
import junit.framework.AssertionFailedError;
import org.slf4j.Logger;

import java.io.IOException;
import java.sql.SQLException;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

public class MultipleColumnTypeHTTP implements E2ECase {
    private final Logger l = TestLogger.init(this.getClass());

    private final Main.mxgateHelper mxgateHelper;
    final static DBHelper dbHelper = new DBHelper();
    private final DataUtils dataMaker = new DataUtils();

    final private MxBuilder builder;
    private int grpcPort;

    public MultipleColumnTypeHTTP(MxBuilder builder, Main.mxgateHelper mxgateHelper) {
        this.mxgateHelper = mxgateHelper;
        this.builder = builder;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void execute() throws AssertionError, IOException, SQLException {
        String schema = "public";
        String tableName = String.format("%s_table_0001", this.getClass().getSimpleName()).toLowerCase();

        // prepare
        dbHelper.createTable(String.format("CREATE TABLE IF NOT EXISTS %1$s.%2$s (time TIMESTAMP, tagid SERIAL, c1 BOOLEAN, c2 CHAR(5), c3 NUMERIC(15,5), c4 JSON, c5 JSONB, c6 TIME WITH TIME ZONE, c7 UUID) DISTRIBUTED BY (tagid); TRUNCATE %1$s.%2$s", schema, tableName));

        // start mxgate
        String configStr = String.format("[source]\n" +
                "\tsource = \"http\"\n" +
                "\t[source.http]\n" +
                "\t\tmax-request-bytes = 3000000\n" +
                "\t\trequest-timeout = 500\n" +
                "[transform]\n" +
                "\ttransform = \"plain\"\n" +
                "[job]\n" +
                "\tallow-dynamic = true\n" +
                "\tdelimiter = \"|\"\n" +
                "\tformat = \"csv\"\n" +
                "\ttime-format = \"unix-ms\"\n" +
                "\t[[job.target]]\n" +
                "\t\tdelimiter = \"|\"\n" +
                "\t\tformat = \"csv\"\n" +
                "\t\tname = \"%1$s.%2$s\"\n" +
                "\t\tschema = \"%1$s\"\n" +
                "\t\ttable = \"%2$s\"\n" +
                "[writer]\n" +
                "\twriter = \"stream\"\n" +
                "[misc]\n" +
                "\tdebug = true\n", schema, tableName);
        mxgateHelper.startWithConfig(dbHelper.getDBName(), configStr);
        this.grpcPort = new LockFiles().getOneGrpcPort();

        String cfgStr = mxgateHelper.getConfig();
        assertTrue("should get mxgate config",cfgStr != null && cfgStr.length() > 0 );

        // call sdk
        int tableCnt = 10;
        String grpcURL = String.format("localhost:%d", this.grpcPort);
        String httpURL = String.format("http://localhost:%d/", new LockFiles().getOneHttpPort());
        this.builder.connect(httpURL, grpcURL, schema, tableName, new ConnectionListener() {
            @Override
            public void onFailure(String failureMsg) {
                throw new AssertionFailedError(String.format("failed to connect to {}: {}", tableName, failureMsg));
            }

            @Override
            public void onSuccess(MxClient client) {
                dataMaker.sendMultipleColumnType(client, 100, 100, tableCnt);
            }
        });

        // send empty tuple
        this.builder.connect(httpURL, grpcURL, schema, tableName, new ConnectionListener() {
            @Override
            public void onFailure(String failureMsg) {
                throw new AssertionFailedError(String.format("failed to connect to {}: {}", tableName, failureMsg));
            }

            @Override
            public void onSuccess(MxClient client) {
                dataMaker.sendMultipleColumnTypeEmpty(client, 100, 100, tableCnt);
            }
        });

        dataMaker.waitProcess();
        try {
            assertEquals(String.format("should count all inserted tuples in %s.%s", schema, tableName), tableCnt*2, dbHelper.countTuple(tableName));
        } catch (SQLException e) {
            throw new AssertionFailedError(String.format("should not catch SQLException when counting tuples: %s", e.getMessage()));
        } catch (AssertionError e) {
            throw e;
        }
    }
}
