package Main.cases.http;

import Main.LockFiles;
import Main.Tools.PrintColor;
import Main.cases.DBHelper;
import Main.cases.DataUtils;
import Main.runner.E2ECase;
import cn.ymatrix.apiclient.MxClient;
import cn.ymatrix.builder.ConnectionListener;
import cn.ymatrix.builder.MxBuilder;
import junit.framework.AssertionFailedError;
import org.junit.Assert;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

public class CircuitBreakerOpenBySlowCallHTTP implements E2ECase {
    private final Main.mxgateHelper mxgateHelper;
    private DBHelper dbHelper = new DBHelper();
    private final DataUtils dataMaker = new DataUtils();

    final private MxBuilder builder;
    private int grpcPort;

    public CircuitBreakerOpenBySlowCallHTTP(MxBuilder builder, Main.mxgateHelper mxgateHelper) {
        this.mxgateHelper = mxgateHelper;
        this.builder = builder;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
    @Override
    public void execute() throws SQLException, IOException {
        dbHelper = new DBHelper();

        String schema = "public";
        String tableName = String.format("%s_table_0001", this.getClass().getSimpleName()).toLowerCase();

        // prepare
        dbHelper.createTable(String.format("CREATE TABLE IF NOT EXISTS %1$s.%2$s (time TIMESTAMP, tagid INT, c1 INT NOT NULL, c2 INT NOT NULL DEFAULT 0, c3 text) DISTRIBUTED BY (tagid);TRUNCATE %1$s.%2$s", schema, tableName));

        // start mxgate
        String configStr = String.format("[source]\n" +
                "\tsource = \"http\"\n" +
                "\t[source.http]\n" +
                "\t\tmax-request-bytes = 3000000\n" +
                "\t\trequest-timeout = 500\n" +
                "[transform]\n" +
                "\ttransform = \"plain\"\n" +
                "[job]\n" +
                "\tallow-dynamic = true\n" +
                "\tdelimiter = \"|\"\n" +
                "\tformat = \"csv\"\n" +
                "\ttime-format = \"unix-ms\"\n" +
                "\t[[job.target]]\n" +
                "\t\tdelimiter = \"|\"\n" +
                "\t\tformat = \"csv\"\n" +
                "\t\tname = \"%1$s.%2$s\"\n" +
                "\t\tschema = \"%1$s\"\n" +
                "\t\ttable = \"%2$s\"\n" +
                "[writer]\n" +
                "\twriter = \"stream\"\n" +
                "[misc]\n" +
                "\tdebug = true\n", schema, tableName);

        System.out.println(configStr);
        mxgateHelper.startWithConfig(dbHelper.getDBName(), configStr);
        this.grpcPort = new LockFiles().getOneGrpcPort();

        String cfgStr = mxgateHelper.getConfig();
        assertTrue("should get mxgate config",cfgStr != null && cfgStr.length() > 0 );

        String grpcURL = String.format("localhost:%d", this.grpcPort);
        String httpURL = String.format("http://localhost:%d/", new LockFiles().getOneHttpPort());
        AtomicInteger failedCnt = new AtomicInteger(); // for wait data process(insert to DB) finish

        MxClient client = this.builder.connect(httpURL, grpcURL, schema, tableName);
        Assert.assertNotNull(client);
        try {
            dataMaker.sendWithCircuitBreakerOnBySlowCall(client, "cn.ymatrix.httpclient.HttpTask", "requestBlockingCore", 1100);
        } catch (Exception e){
            failedCnt.addAndGet(1);
            PrintColor.RedPrint(String.format("[%s] unexpected exception: %s", getName(),e.getMessage()));
        }

        dataMaker.waitProcess();
        try {
            int expectCnt =7;
            int actualCnt = dbHelper.countTuple(tableName);
            assertTrue(String.format("expect at least %d tuples in %s.%s, but get %d", expectCnt, schema, tableName, actualCnt), actualCnt >= expectCnt);
        } catch (SQLException e) {
            throw new AssertionFailedError(String.format("should not catch SQLException when counting tuples: %s", e.getMessage()));
        }
        assertEquals(0, failedCnt.get());
    }
}
