package Main.cases.grpc;

import Main.LockFiles;
import Main.TestLogger;
import Main.cases.DBHelper;
import Main.cases.DataUtils;
import Main.runner.E2ECase;
import cn.ymatrix.apiclient.MxClient;
import cn.ymatrix.builder.MxBuilder;
import junit.framework.AssertionFailedError;
import org.slf4j.Logger;

import java.io.IOException;
import java.sql.SQLException;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

public class SimpleSyncGRPC implements E2ECase {
    private final Logger l = TestLogger.init(this.getClass());

    private final Main.mxgateHelper mxgateHelper;
    final static DBHelper dbHelper = new DBHelper();
    private final DataUtils dataMaker = new DataUtils();

    private final MxBuilder builder;
    private int grpcPort;

    public SimpleSyncGRPC(MxBuilder builder, Main.mxgateHelper mxgateHelper) {
        this.mxgateHelper = mxgateHelper;
        this.builder = builder;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void execute() throws AssertionError, IOException, SQLException {
        String schema = "public";
        String tableName = String.format("%s_table_0001", this.getClass().getSimpleName()).toLowerCase();

        // prepare
        dbHelper.createTable(String.format("CREATE TABLE IF NOT EXISTS %1$s.%2$s (time TIMESTAMP, tagid INT, c1 INT NOT NULL, c2 INT NOT NULL DEFAULT 0, c3 text) DISTRIBUTED BY (tagid);TRUNCATE %1$s.%2$s", schema, tableName));

        // start mxgate
        String configStr = String.format("[source]\n" +
                "\tsource = \"grpc\"\n" +
                "\t[source.grpc]\n" +
                "\t\tmax-request-bytes = 3000000\n" +
                "\t\trequest-timeout = 1000\n" +
                "[transform]\n" +
                "\ttransform = \"plain\"\n" +
                "[job]\n" +
                "\tallow-dynamic = true\n" +
                "\tdelimiter = \"|\"\n" +
                "\tformat = \"csv\"\n" +
                "\ttime-format = \"unix-ms\"\n" +
                "\t[[job.target]]\n" +
                "\t\tdelimiter = \"|\"\n" +
                "\t\tformat = \"csv\"\n" +
                "\t\tname = \"%1$s.%2$s\"\n" +
                "\t\tschema = \"%1$s\"\n" +
                "\t\ttable = \"%2$s\"\n" +
                "[writer]\n" +
                "\twriter = \"stream\"\n" +
                "[misc]\n" +
                "\tdebug = true\n", schema, tableName);

        System.out.println(configStr);
        mxgateHelper.startWithConfig(dbHelper.getDBName(), configStr);
        this.grpcPort = new LockFiles().getOneGrpcPort();

        String cfgStr = mxgateHelper.getConfig();
        assertTrue("should get mxgate config", cfgStr != null && cfgStr.length() > 0);

        // call sdk
        int tableCnt = 1000;
        String grpcURL = String.format("localhost:%d", this.grpcPort);

        MxClient client = this.builder.connect(grpcURL, grpcURL, schema, tableName);
        dataMaker.syncSendNormal(client, 50, tableCnt);

        try {

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {

            }

            assertEquals(String.format("should count all inserted tuples in %s.%s", schema, tableName), tableCnt, dbHelper.countTuple(tableName));
        } catch (SQLException e) {
            e.printStackTrace();
            throw new AssertionFailedError(String.format("should not catch SQLException when counting tuples: %s", e.getMessage()));
        }
    }
}
