/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflexUtils {
    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String fieldName, Class<?> ... o) {
        try {
            return clazz.getDeclaredMethod(fieldName, o);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            return superClass == null ? null : ReflexUtils.getMethod(superClass, fieldName, new Class[0]);
        }
    }

    public static Object invokeMethod(@NotNull Method method, @Nullable Object by, Object ... param) {
        method.setAccessible(true);
        try {
            return method.invoke(by, param);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Field> getFields(@NotNull Class<?> type) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> clazz = type; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!list.isEmpty()) {
                list.addAll(0, Arrays.asList(clazz.getDeclaredFields()));
                continue;
            }
            Collections.addAll(list, clazz.getDeclaredFields());
        }
        return list;
    }

    @Nullable
    public static Field getField(@NotNull Class<?> type, @NotNull String fieldName) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Object getFieldValue(@NotNull Object object, @NotNull String fieldName) {
        try {
            Class<?> clazz = object.getClass();
            Field field = ReflexUtils.getField(clazz, fieldName);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

