/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.database.sql.executor;

import cn.yingyya.next.moment.api.database.DataConnector;
import cn.yingyya.next.moment.api.database.sql.SQLColumn;
import cn.yingyya.next.moment.api.database.sql.SQLExecute;
import cn.yingyya.next.moment.api.database.sql.SQLExecutor;
import cn.yingyya.next.moment.api.database.sql.SQLValue;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class InsertQueryExecutor
extends SQLExecutor<Void> {
    private final List<SQLValue> values = new ArrayList<SQLValue>();

    protected InsertQueryExecutor(@NotNull String table) {
        super(table);
    }

    @NotNull
    public static InsertQueryExecutor builder(@NotNull String table) {
        return new InsertQueryExecutor(table);
    }

    @NotNull
    public InsertQueryExecutor values(SQLValue ... values) {
        return this.values(Arrays.asList(values));
    }

    @NotNull
    public InsertQueryExecutor values(@NotNull List<SQLValue> values) {
        this.values.clear();
        this.values.addAll(values);
        return this;
    }

    @Override
    @NotNull
    public Void execute(@NotNull DataConnector<?> connector) {
        if (this.values.isEmpty()) {
            return null;
        }
        Object obj = connector.dataSource();
        if (!(obj instanceof HikariDataSource)) {
            return null;
        }
        HikariDataSource dataSource = (HikariDataSource)obj;
        String columns = this.values.stream().map(SQLValue::column).map(SQLColumn::getNameEscaped).collect(Collectors.joining(","));
        String values = this.values.stream().map(value -> "?").collect(Collectors.joining(","));
        String sql = "INSERT INTO " + this.getTable() + "(" + columns + ") VALUES(" + values + ")";
        List<String> value2 = this.values.stream().map(SQLValue::value).toList();
        SQLExecute.executeStatement(dataSource, sql, value2);
        return null;
    }
}

