/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment;

import cn.yingyya.next.moment.api.config.ConfigOption;
import cn.yingyya.next.moment.api.manager.CommandManager;
import cn.yingyya.next.moment.api.manager.DataBaseManager;
import cn.yingyya.next.moment.api.manager.EventManager;
import cn.yingyya.next.moment.api.manager.PermissionManager;
import cn.yingyya.next.moment.utils.ReflexUtils;
import cn.yingyya.next.moment.utils.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NextPlugin<T extends NextPlugin<T>>
extends JavaPlugin {
    private EventManager<T> eventManager;
    private CommandManager<T> commandManager;
    private PermissionManager<T> permissionManager;
    private DataBaseManager<T> dataBaseManager;
    private final LinkedHashMap<Class<?>, Pair<File, YamlConfiguration>> configMap = new LinkedHashMap();
    private static final HashMap<Class<?>, NextPlugin<?>> pluginMap = new HashMap();

    public abstract void onNextLoad();

    public abstract void onNextUnload();

    @NotNull
    public abstract T getPluginInstance();

    public void onEnable() {
        this.dataBaseManager = new DataBaseManager<T>(this.getPluginInstance());
        this.permissionManager = new PermissionManager<T>(this.getPluginInstance());
        this.eventManager = new EventManager<T>(this.getPluginInstance());
        this.commandManager = new CommandManager<T>(this.getPluginInstance());
        this.onNextLoad();
        pluginMap.put(this.getPluginInstance().getClass(), (NextPlugin<?>)((Object)this.getPluginInstance()));
        this.dataBaseManager.onLoad();
        this.permissionManager.onLoad();
        this.eventManager.onLoad();
        this.commandManager.onLoad();
    }

    public void onDisable() {
        this.onNextUnload();
        pluginMap.remove(this.getPluginInstance().getClass());
        this.eventManager.onUnload();
        this.commandManager.onUnload();
        this.permissionManager.onUnload();
        this.dataBaseManager.onUnload();
    }

    @Nullable
    public static <T extends NextPlugin<T>> NextPlugin<T> getNextPlugin(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (!pluginMap.containsKey(clazz)) {
            return null;
        }
        return pluginMap.get(clazz);
    }

    public void loadNextConfig(@NotNull Class<?> clazz) {
        this.loadNextConfig(clazz, "config.yml");
    }

    public void loadNextConfig(@NotNull Class<?> clazz, @NotNull String configPath) {
        File path = new File(this.getDataFolder(), configPath);
        if (configPath.equals("config.yml")) {
            super.saveDefaultConfig();
            super.reloadConfig();
        } else if (!path.exists()) {
            path.getParentFile().mkdirs();
            try {
                path.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)path);
            configuration.load(path);
            this.configMap.put(clazz, Pair.create(path, configuration));
            this.injectionConfigOfObject(clazz, configuration);
        }
        catch (IOException | IllegalAccessException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    private void injectionConfigOfObject(@NotNull Class<?> clazz, @NotNull YamlConfiguration configuration) throws IllegalAccessException {
        List<Field> fields = ReflexUtils.getFields(clazz).stream().filter(v -> v.canAccess(null) && v.getType() == ConfigOption.class).toList();
        for (Field field : fields) {
            Object o1 = field.get(null);
            if (!(o1 instanceof ConfigOption)) continue;
            ConfigOption option = (ConfigOption)o1;
            option.setConfiguration(configuration);
        }
    }

    public void reloadNextConfig(Class<?> clazz) {
        Pair<File, YamlConfiguration> pair = this.getConfig(clazz);
        File file = pair.getLeft();
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        this.configMap.put(clazz, Pair.create(file, configuration));
        try {
            this.injectionConfigOfObject(clazz, configuration);
            this.getLogger().info("reloaded configuration for " + clazz.getName());
        }
        catch (IllegalAccessException e) {
            this.getLogger().info("failed to reload configuration for " + clazz.getName());
            e.printStackTrace();
        }
    }

    public void saveNextConfig(Class<?> clazz) {
        Pair<File, YamlConfiguration> config = this.getConfig(clazz);
        File file = config.getLeft();
        YamlConfiguration configuration = config.getRight();
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            this.getLogger().info("Save config failed in file " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private Pair<File, YamlConfiguration> getConfig(Class<?> clazz) {
        for (Class<?> key : this.configMap.keySet()) {
            if (key != clazz) continue;
            return this.configMap.get(key);
        }
        throw new IllegalStateException("No config found for " + clazz.getName());
    }

    public EventManager<T> getEventManager() {
        return this.eventManager;
    }

    public PluginManager getPluginManager() {
        return this.getServer().getPluginManager();
    }

    public CommandManager<T> getCommandManager() {
        return this.commandManager;
    }

    public PermissionManager<T> getPermissionManager() {
        return this.permissionManager;
    }

    public DataBaseManager<T> getDataBaseManager() {
        return this.dataBaseManager;
    }

    public BukkitScheduler getScheduler() {
        return this.getServer().getScheduler();
    }
}

