/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.manager;

import cn.yingyya.next.moment.NextPlugin;
import cn.yingyya.next.moment.api.database.DataConnector;
import cn.yingyya.next.moment.api.manager.Manager;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBaseManager<T extends NextPlugin<T>>
extends Manager<T> {
    private final HashMap<String, DataConnector<?>> dataSources = new HashMap();
    private String defaultDataSourceName;

    public DataBaseManager(T plugin) {
        super(plugin);
    }

    public boolean setDefaultData(@NotNull String key) {
        if (this.dataSources.containsKey(key)) {
            this.defaultDataSourceName = key;
            return true;
        }
        return false;
    }

    @Nullable
    public DataConnector<?> getDefaultDataSource() {
        if (this.defaultDataSourceName == null) {
            return null;
        }
        if (this.dataSources.containsKey(this.defaultDataSourceName)) {
            return this.dataSources.get(this.defaultDataSourceName);
        }
        return null;
    }

    public void addDataBase(@Nullable DataConnector<?> dataConnector) throws IllegalAccessException {
        if (dataConnector == null) {
            throw new IllegalArgumentException("dataConnector is null");
        }
        String name = dataConnector.name();
        if (this.dataSources.containsKey(name)) {
            throw new IllegalAccessException("Database duplication initiated.");
        }
        this.dataSources.put(name, dataConnector);
        if (this.defaultDataSourceName == null) {
            this.defaultDataSourceName = name;
        }
    }

    @Nullable
    public DataConnector<?> getDataConnector(@NotNull String name) {
        return this.dataSources.get(name);
    }

    @Override
    public void onLoad() {
    }

    @Override
    public void onUnload() {
        this.dataSources.forEach((key, value) -> {
            HikariDataSource hikariDataSource;
            Object patt1757$temp = value.dataSource();
            if (patt1757$temp instanceof HikariDataSource && (hikariDataSource = (HikariDataSource)patt1757$temp).isRunning()) {
                hikariDataSource.close();
            }
        });
    }
}

