/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.database.sql.executor;

import cn.yingyya.next.moment.api.database.DataBaseType;
import cn.yingyya.next.moment.api.database.DataConnector;
import cn.yingyya.next.moment.api.database.sql.ColumnFormat;
import cn.yingyya.next.moment.api.database.sql.SQLColumn;
import cn.yingyya.next.moment.api.database.sql.SQLExecute;
import cn.yingyya.next.moment.api.database.sql.SQLExecutor;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CreateTableExecutor
extends SQLExecutor<Void> {
    private final DataBaseType type;
    private final List<SQLColumn> columns;

    protected CreateTableExecutor(@NotNull String table, @NotNull DataBaseType type) {
        super(table);
        this.type = type;
        this.columns = new ArrayList<SQLColumn>();
    }

    @NotNull
    public static CreateTableExecutor builder(@NotNull String table, @NotNull DataBaseType type) {
        return new CreateTableExecutor(table, type);
    }

    @NotNull
    public CreateTableExecutor columns(SQLColumn ... columns) {
        return this.columns(Arrays.asList(columns));
    }

    @NotNull
    public CreateTableExecutor columns(@NotNull List<SQLColumn> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
        return this;
    }

    @Override
    @NotNull
    public Void execute(@NotNull DataConnector<?> connector) {
        if (this.columns.isEmpty()) {
            return null;
        }
        Object obj = connector.dataSource();
        if (!(obj instanceof HikariDataSource)) {
            return null;
        }
        HikariDataSource dataSource = (HikariDataSource)obj;
        String id = "`id` " + ColumnFormat.INTEGER.format(this.type, 11);
        id = this.type == DataBaseType.SQLITE ? id + " PRIMARY KEY AUTOINCREMENT" : id + " PRIMARY KEY AUTO_INCREMENT";
        String columns = id + "," + this.columns.stream().map(column -> column.getNameEscaped() + " " + column.formatType(this.type)).collect(Collectors.joining(", "));
        String sql = "CREATE TABLE IF NOT EXISTS " + this.getTable() + "(" + columns + ");";
        SQLExecute.executeStatement(dataSource, sql);
        return null;
    }
}

