/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.database.sql;

import cn.yingyya.next.moment.api.database.DataBaseType;
import org.jetbrains.annotations.NotNull;

public interface ColumnFormat {
    public static final ColumnFormat STRING = (type, length) -> {
        if (length < 1 || type == DataBaseType.SQLITE) {
            return type == DataBaseType.SQLITE ? "text not null" : "mediumtext not null";
        }
        return "varchar(" + length + ") character SET utf8 not null";
    };
    public static final ColumnFormat INTEGER = (type, length) -> {
        if (length < 1 || type == DataBaseType.SQLITE) {
            return "integer not null";
        }
        return "int(" + length + ") not null";
    };
    public static final ColumnFormat DOUBLE = (type, length) -> type == DataBaseType.SQLITE ? "real not null" : "double not null";
    public static final ColumnFormat LONG = (type, length) -> length < 1 || type == DataBaseType.SQLITE ? "bigint not null" : "bigint(" + length + ") not null";
    public static final ColumnFormat BOOLEAN = (type, length) -> type == DataBaseType.SQLITE ? "integer not null" : "tinyint(1) not null";

    @NotNull
    public String format(@NotNull DataBaseType var1, int var2);
}

