/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.config;

import cn.yingyya.next.moment.api.config.ConfigReader;
import cn.yingyya.next.moment.api.config.ConfigWriter;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class ConfigOption<T> {
    public static final ConfigReader<String> StringReader = (path, value, configuration) -> configuration.getString(path, value);
    public static final ConfigReader<Integer> IntegerReader = (path, value, configuration) -> configuration.getInt(path, value.intValue());
    public static final ConfigReader<Long> LongReader = (path, value, configuration) -> configuration.getLong(path, value.longValue());
    public static final ConfigReader<Boolean> BooleanReader = (path, value, configuration) -> configuration.getBoolean(path, value.booleanValue());
    public static final ConfigReader<Double> DoubleReader = (path, value, configuration) -> configuration.getDouble(path, value.doubleValue());
    public static final ConfigReader<Color> ColorReader = (path, value, configuration) -> configuration.getColor(path, value);
    public static final ConfigReader<Object> ObjectReader = (path, value, configuration) -> configuration.get(path, value);
    public static final ConfigReader<ItemStack> ItemStackReader = (path, value, configuration) -> configuration.getItemStack(path, value);
    public static final ConfigReader<Location> LocationReader = (path, value, configuration) -> configuration.getLocation(path, value);
    public static final ConfigReader<List<?>> ListReader = (path, value, configuration) -> configuration.getList(path, value);
    public static final ConfigReader<List<Long>> LongListReader = (path, value, configuration) -> configuration.getLongList(path);
    public static final ConfigReader<List<String>> StringListReader = (path, value, configuration) -> configuration.getStringList(path);
    public static final ConfigReader<List<Integer>> IntegerListReader = (path, value, configuration) -> configuration.getIntegerList(path);
    public static final ConfigReader<List<Boolean>> BooleanListReader = (path, value, configuration) -> configuration.getBooleanList(path);
    public static final ConfigReader<List<Double>> DoubleListReader = (path, value, configuration) -> configuration.getDoubleList(path);
    public static final ConfigReader<List<Map<?, ?>>> MapListReader = (path, value, configuration) -> configuration.getMapList(path);
    private final String path;
    private final T defaultValue;
    private final ConfigReader<T> reader;
    private final ConfigWriter<T> writer;
    private YamlConfiguration configuration;

    private ConfigOption(String path, T defaultValue, ConfigReader<T> reader, ConfigWriter<T> writer) {
        this.path = path;
        this.defaultValue = defaultValue;
        this.reader = reader;
        this.writer = writer;
    }

    private ConfigOption(String path, T defaultValue, ConfigReader<T> reader) {
        this(path, defaultValue, reader, (p, v, c) -> c.set(p, v));
    }

    public void setConfiguration(YamlConfiguration configuration) {
        this.configuration = configuration;
    }

    public T get() {
        if (this.configuration == null) {
            return this.defaultValue;
        }
        T read = this.reader.read(this.path, this.defaultValue, this.configuration);
        if (read == null) {
            return this.defaultValue;
        }
        return read;
    }

    public void set(T value) {
        if (this.configuration != null) {
            this.writer.write(this.path, value, this.configuration);
        }
    }

    public static <T> ConfigOption<T> of(String path, T defaultValue, ConfigReader<T> getter, ConfigWriter<T> setter) {
        return new ConfigOption<T>(path, defaultValue, getter, setter);
    }

    public static <T> ConfigOption<T> of(String path, T defaultValue, ConfigReader<T> getter) {
        return new ConfigOption<T>(path, defaultValue, getter);
    }
}

