/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.manager;

import cn.yingyya.next.moment.NextPlugin;
import cn.yingyya.next.moment.api.command.NextCommand;
import cn.yingyya.next.moment.api.command.NextCommandMiddleware;
import cn.yingyya.next.moment.api.manager.Manager;
import cn.yingyya.next.moment.utils.ReflexUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.SimpleCommandMap;
import org.jetbrains.annotations.NotNull;

public class CommandManager<T extends NextPlugin<T>>
extends Manager<T> {
    private final List<NextCommand<T>> commands = new ArrayList<NextCommand<T>>();

    public CommandManager(@NotNull T plugin) {
        super(plugin);
    }

    public SimpleCommandMap getCommandMap() {
        return (SimpleCommandMap)ReflexUtils.getFieldValue(Bukkit.getServer(), "commandMap");
    }

    public void syncServerCommand() {
        Server server = Bukkit.getServer();
        Method syncCommands = ReflexUtils.getMethod(server.getClass(), "syncCommands", new Class[0]);
        if (syncCommands == null) {
            return;
        }
        ReflexUtils.invokeMethod(syncCommands, server, new Object[0]);
        this.getPlugin().getLogger().info("Sync server command finished.");
    }

    public void registerCommand(NextCommand<T> command) {
        if (this.commands.contains(command)) {
            this.getPlugin().getLogger().warning(String.format("%s command already load", command.getCommandName()));
            return;
        }
        this.getPlugin().getLogger().info(String.format("%s command load success", command.getCommandName()));
        this.commands.add(command);
    }

    @Override
    public void onLoad() {
        this.getPlugin().getLogger().warning(String.format("Start of registration commands, totaling %d.", this.commands.size()));
        for (NextCommand<T> command : this.commands) {
            NextCommandMiddleware<T> nextCommandMiddleware = new NextCommandMiddleware<T>(command);
            this.getCommandMap().register(command.getCommandName(), nextCommandMiddleware);
        }
        this.syncServerCommand();
    }

    @Override
    public void onUnload() {
    }
}

