/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.database.sql.executor;

import cn.yingyya.next.moment.api.database.DataConnector;
import cn.yingyya.next.moment.api.database.sql.SQLColumn;
import cn.yingyya.next.moment.api.database.sql.SQLColumnType;
import cn.yingyya.next.moment.api.database.sql.SQLCondition;
import cn.yingyya.next.moment.api.database.sql.SQLExecute;
import cn.yingyya.next.moment.api.database.sql.SQLExecutor;
import cn.yingyya.next.moment.api.database.sql.SQLValue;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SelectQueryExecutor<T>
extends SQLExecutor<List<T>> {
    private final List<SQLColumn> columns = new ArrayList<SQLColumn>();
    private final List<SQLCondition> wheres = new ArrayList<SQLCondition>();
    private final Function<ResultSet, T> dataFunction;
    private int amount;

    protected SelectQueryExecutor(@NotNull String table, @NotNull Function<ResultSet, T> dataFunction) {
        super(table);
        this.dataFunction = dataFunction;
        this.amount = -1;
    }

    @Override
    @NotNull
    public List<T> execute(@NotNull DataConnector<?> connector) {
        if (this.columns.isEmpty()) {
            return Collections.emptyList();
        }
        Object obj = connector.dataSource();
        if (!(obj instanceof HikariDataSource)) {
            return Collections.emptyList();
        }
        HikariDataSource dataSource = (HikariDataSource)obj;
        String columns = this.columns.stream().map(SQLColumn::getNameEscaped).collect(Collectors.joining(","));
        String wheres = this.wheres.stream().map(where -> where.value().column().getNameEscaped() + " " + where.type().getOperator() + " ?").collect(Collectors.joining(" AND "));
        String sql = "SELECT " + columns + " FROM " + this.getTable() + (String)(wheres.isEmpty() ? "" : " WHERE " + wheres);
        List<String> where2 = this.wheres.stream().map(SQLCondition::value).map(SQLValue::value).toList();
        return SQLExecute.executeQuery(dataSource, sql, where2, this.dataFunction, this.amount);
    }

    @NotNull
    public static <T> SelectQueryExecutor<T> builder(@NotNull String table, @NotNull Function<ResultSet, T> dataFunction) {
        return new SelectQueryExecutor<T>(table, dataFunction);
    }

    @NotNull
    public SelectQueryExecutor<T> all() {
        return this.columns(new SQLColumn("*", SQLColumnType.STRING, -1));
    }

    @NotNull
    public SelectQueryExecutor<T> columns(SQLColumn ... columns) {
        return this.columns(Arrays.asList(columns));
    }

    @NotNull
    public SelectQueryExecutor<T> columns(@NotNull List<SQLColumn> columns) {
        if (columns.isEmpty()) {
            return this.all();
        }
        this.columns.clear();
        this.columns.addAll(columns);
        return this;
    }

    @NotNull
    public SelectQueryExecutor<T> where(SQLCondition ... wheres) {
        return this.where(Arrays.asList(wheres));
    }

    @NotNull
    public SelectQueryExecutor<T> where(@NotNull List<SQLCondition> wheres) {
        this.wheres.clear();
        this.wheres.addAll(wheres);
        return this;
    }

    @NotNull
    public SelectQueryExecutor<T> amount(int amount) {
        this.amount = amount;
        return this;
    }
}

