/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.database.kv;

import cn.yingyya.next.moment.api.database.DataConnector;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.rocksdb.FlushOptions;
import org.rocksdb.Holder;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class KVExecute {
    private final RocksDB db;

    public KVExecute(@NotNull DataConnector<?> dataConnector) {
        if (dataConnector.dataSource() instanceof RocksDB) {
            this.db = (RocksDB)dataConnector.dataSource();
        }
        throw new IllegalStateException("DataConnector is not a LevelDB instance");
    }

    public static KVExecute of(@NotNull DataConnector<?> dataConnector) {
        return new KVExecute(dataConnector);
    }

    public boolean set(byte[] key, byte[] value) {
        try {
            this.db.put(key, value);
            return true;
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte[] get(byte[] key, byte[] defaultValue) {
        try {
            byte[] bytes = this.db.get(key);
            return (byte[])(bytes != defaultValue ? bytes : null);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public boolean delete(byte[] key) {
        try {
            this.db.delete(key);
            return true;
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteRange(byte[] start, byte[] end) {
        try {
            this.db.deleteRange(start, end);
            return true;
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean flush() {
        try {
            this.db.flush(new FlushOptions());
            return true;
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<byte[]> multiGetAsList(List<byte[]> keys) {
        try {
            List bytes = this.db.multiGetAsList(keys);
            if (bytes == null) {
                return Collections.emptyList();
            }
            return bytes;
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public Map<byte[], byte[]> multiGetAsMap(List<byte[]> keys) {
        try {
            return this.db.multiGet(keys);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
    }

    public boolean keyMayExist(byte[] key) {
        try {
            Holder holder = new Holder();
            return this.db.keyMayExist(key, holder);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Map<byte[], byte[]> getAll() {
        HashMap<byte[], byte[]> map = new HashMap<byte[], byte[]>();
        try (RocksIterator iterator = this.db.newIterator();){
            iterator.seekToFirst();
            while (iterator.isValid()) {
                map.put(iterator.key(), iterator.value());
                iterator.next();
            }
        }
        return map;
    }
}

