/*
 * Decompiled with CFR 0.152.
 */
package cn.yingyya.next.moment.api.command;

import cn.yingyya.next.moment.NextPlugin;
import cn.yingyya.next.moment.api.command.NextCommand;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;

public class NextCommandMiddleware<T extends NextPlugin<T>>
extends Command {
    private final NextCommand<T> command;

    public NextCommandMiddleware(@NotNull NextCommand<T> command) {
        super(command.getCommandName(), command.getDescription(), command.getUsage(), command.getAliases());
        this.command = command;
    }

    public NextCommand<T> getMatchesCommand(NextCommand<T> command, String[] args) {
        NextCommand cmd = command;
        boolean retNull = false;
        for (String arg : args) {
            if (cmd.isRootCommand() || cmd.getChildren() == null) {
                return cmd;
            }
            Optional<NextCommand> optional = cmd.getChildren().stream().filter(v -> arg.equals(v.getCommandName())).findFirst();
            if (optional.isPresent()) {
                cmd = optional.get();
                retNull = false;
                continue;
            }
            retNull = true;
        }
        return retNull ? null : cmd;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String s, @NotNull String[] strings) {
        NextCommand<T> executeCommand;
        String[] newStrings = new String[strings.length + 1];
        newStrings[0] = s;
        System.arraycopy(strings, 0, newStrings, 1, strings.length);
        NextCommand<T> nextCommand = executeCommand = this.command.isRootCommand() ? this.command : this.getMatchesCommand(this.command, newStrings);
        if (executeCommand == null) {
            sender.sendMessage(this.command.getUsage());
            return true;
        }
        Permission permission = executeCommand.getPermission(strings);
        if (permission != null && !sender.hasPermission(permission)) {
            sender.sendMessage("You do not have permission to execute this command.");
            return true;
        }
        executeCommand.onExecute(sender, strings);
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        if (this.command.isRootCommand()) {
            return this.command.onTabComplete(sender, args);
        }
        NextCommand<T> matchesCommand = this.getMatchesCommand(this.command, args);
        if (matchesCommand == null) {
            List<String> strings = this.command.onTabComplete(sender, args);
            if (strings.isEmpty()) {
                return Collections.emptyList();
            }
            return strings;
        }
        Set<NextCommand<T>> children = matchesCommand.getChildren();
        List<String> strings = matchesCommand.onTabComplete(sender, args);
        if (!strings.isEmpty()) {
            return strings;
        }
        if (children != null) {
            return children.stream().filter(v -> {
                Permission permission = v.getPermission(args);
                return permission == null || sender.hasPermission(permission);
            }).map(NextCommand::getCommandName).toList();
        }
        return Collections.emptyList();
    }
}

