/*
 * Decompiled with CFR 0.152.
 */
package cn.yerl.web.mail;

import cn.yerl.web.mail.MailAddress;
import cn.yerl.web.mail.WebMailRequest;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class WebMailClient {
    private final Session session;
    private final Properties props;
    private MailAddress from = null;

    public WebMailClient(Properties props) {
        this.props = props;
        this.session = Session.getDefaultInstance((Properties)props);
    }

    public WebMailClient setForm(MailAddress address) {
        this.from = address;
        return this;
    }

    public MailAddress getFrom() {
        return this.from;
    }

    public void send(WebMailRequest request) throws Exception {
        Transport transport = this.session.getTransport();
        transport.connect(this.props.getProperty("mail.smtp.user"), this.props.getProperty("mail.smtp.password"));
        MimeMessage message = new MimeMessage(this.session);
        if (request.getFrom() == null) {
            if (this.from == null) {
                throw new IllegalArgumentException("\u6ca1\u6709\u8bbe\u7f6e\u53d1\u4ef6\u4eba");
            }
            message.setFrom((Address)new InternetAddress(this.from.getAddress(), this.from.getPersonal(), "UTF-8"));
        } else {
            message.setFrom((Address)new InternetAddress(request.getFrom().getAddress(), request.getFrom().getPersonal(), "UTF-8"));
        }
        request.getTo().forEach(it -> {
            try {
                message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(it.getAddress(), it.getPersonal(), "UTF-8"));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        request.getCc().forEach(it -> {
            try {
                message.addRecipient(MimeMessage.RecipientType.CC, (Address)new InternetAddress(it.getAddress(), it.getPersonal(), "UTF-8"));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        request.getBcc().forEach(it -> {
            try {
                message.addRecipient(MimeMessage.RecipientType.BCC, (Address)new InternetAddress(it.getAddress(), it.getPersonal(), "UTF-8"));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        message.setSubject(request.getSubject());
        message.setContent((Object)request.getContent(), "text/html;charset=UTF-8");
        message.setSentDate(new Date());
        message.saveChanges();
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", "smtp.exmail.qq.com");
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.port", "465");
        props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.socketFactory.port", "465");
        props.setProperty("mail.smtp.user", "gitlab@codesync.cn");
        props.setProperty("mail.smtp.password", "Minstone123");
        WebMailClient client = new WebMailClient(props);
        WebMailRequest request = new WebMailRequest().from(new MailAddress("gitlab@codesync.cn", "Archives")).to(new MailAddress("yerl@minstone.com.cn", "\u53f6\u745e\u9f99")).withSubject("\u8fd9\u662f\u6d4b\u8bd5\u90ae\u4ef6").withContent("<h1>Hello</h1>");
        client.send(request);
    }
}

