/*
 * Decompiled with CFR 0.152.
 */
package cn.yerl.web.spring.sso;

import cn.yerl.web.http.WebHttpRequest;
import cn.yerl.web.kit.Render;
import cn.yerl.web.kit.StrKit;
import cn.yerl.web.spring.api.ApiResult;
import cn.yerl.web.spring.api.ApiStatus;
import cn.yerl.web.spring.sso.model.Token;
import cn.yerl.web.spring.sso.properties.SSOProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.CaseInsensitiveContainerFactory;
import com.jfinal.plugin.activerecord.IContainerFactory;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.OracleDialect;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Configuration
@EnableConfigurationProperties(value={SSOProperties.class})
@Controller
@EnableScheduling
public class SSOClient
extends WebSecurityConfigurerAdapter
implements AuthenticationSuccessHandler,
AuthenticationFailureHandler {
    private static Logger logger = LoggerFactory.getLogger(SSOClient.class);
    @Autowired
    SSOProperties properties;
    private static final ThreadLocal<SimpleDateFormat> sdf = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    private Map<String, WebHttpRequest> returnUrls = new HashMap<String, WebHttpRequest>();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Scheduled(fixedRate=60000L)
    public void clearReturnUrls() {
        ArrayList willRemove = new ArrayList();
        long current = new Date().getTime();
        this.returnUrls.entrySet().forEach(entry -> {
            if (current - ((WebHttpRequest)entry.getValue()).getTimestamp() > 60000L) {
                willRemove.add(entry.getKey());
            }
        });
        willRemove.forEach(token -> this.returnUrls.remove(token));
        if (willRemove.size() > 0) {
            logger.info("\u3010\u6e05\u9664\u672a\u4f7f\u7528\u7684token\u3011\u672c\u6b21\u5171\u6e05\u9664\u3010" + willRemove.size() + "\u3011\u4e2a\uff0c\u5269\u4f59\u3010" + this.returnUrls.size() + "\u3011\u4e2a");
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint(this.loginUrlAuthenticationEntryPoint()).accessDeniedPage("/api/security/login/failure").and()).authorizeRequests().antMatchers(new String[]{"/api/disk/**", "/api/message/push", "/api/security/validate", "/api/security/login/failure", "/"})).permitAll().anyRequest()).authenticated().and()).csrf().disable()).formLogin().loginProcessingUrl("/api/security/login")).permitAll()).usernameParameter("token").passwordParameter("auth_code").successHandler((AuthenticationSuccessHandler)this)).failureHandler((AuthenticationFailureHandler)this)).and()).logout().logoutUrl("/api/security/logout").logoutSuccessUrl("/api/security/logout/success").permitAll();
    }

    @GetMapping(value={"/api/security/validate"})
    public void validate(@RequestParam(value="token") String token, @RequestParam(value="auth_code") String authCode, HttpServletRequest request, HttpServletResponse response) throws Exception {
        URIBuilder authUri = new URIBuilder();
        authUri.setScheme(request.getScheme());
        authUri.setHost(request.getLocalAddr());
        authUri.setPort(request.getLocalPort());
        authUri.setPath("/mobile-oa/api/security/login");
        WebHttpRequest authRequest = WebHttpRequest.POST((String)authUri.build().toString()).withBodyParam("token", (Object)token).withBodyParam("auth_code", (Object)authCode);
        authRequest.copyHeader(request);
        try {
            authRequest.rewrite(response);
        }
        catch (Exception ex) {
            logger.error("login rewrite error", (Throwable)ex);
        }
    }

    @GetMapping(value={"/api/security/rewrite"})
    public void rewrite(@RequestParam(value="token") String token, HttpServletRequest request, HttpServletResponse response) {
        WebHttpRequest returnReq = this.returnUrls.remove(token);
        returnReq.copyHeader(request);
        try {
            returnReq.rewrite(response);
        }
        catch (Exception ex) {
            logger.error("rewrite error", (Throwable)ex);
        }
    }

    public AuthenticationEntryPoint loginUrlAuthenticationEntryPoint() throws Exception {
        LoginUrlAuthenticationEntryPoint entryPoint = new LoginUrlAuthenticationEntryPoint(""){

            protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
                String loginUrl;
                String token = UUID.randomUUID().toString();
                try {
                    URIBuilder loginUri = new URIBuilder(SSOClient.this.properties.getServerAddress() + "/sso-server/authorize");
                    loginUri.addParameter("token", token);
                    loginUri.addParameter("request_uri", SSOClient.this.properties.getApplicationAddress() + "/api/security/validate");
                    loginUrl = loginUri.build().toString();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                WebHttpRequest returnReq = new WebHttpRequest(request);
                SSOClient.this.returnUrls.put(token, returnReq);
                StringBuilder builder = new StringBuilder("Authentication report -------------- ").append(((SimpleDateFormat)sdf.get()).format(new Date())).append(" -----------------\r\n");
                builder.append("Redirect to authenticate address: ").append(loginUrl).append("\r\n");
                builder.append("Rewrite address: ").append(returnReq.getUrl()).append("\r\n");
                builder.append("------------------------------------------------------------------------------");
                logger.info(builder.toString());
                return loginUrl;
            }
        };
        return entryPoint;
    }

    @Bean(destroyMethod="stop")
    ActiveRecordPlugin activeRecordPlugin(@Qualifier(value="dataSource") DataSource dataSource) {
        ActiveRecordPlugin record = new ActiveRecordPlugin(dataSource);
        record.addMapping("SSO_TOKEN", "AUTH_CODE", Token.class);
        record.setDevMode(true);
        record.setDialect((Dialect)new OracleDialect());
        record.setTransactionLevel(2);
        record.setContainerFactory((IContainerFactory)new CaseInsensitiveContainerFactory());
        record.start();
        return record;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String remoteUser = (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        request.getSession().setAttribute("remoteUser", (Object)remoteUser);
        WebHttpRequest returnReq = this.returnUrls.get(request.getParameter("token"));
        StringBuilder builder = new StringBuilder("Authentication report -------------- ").append(sdf.get().format(new Date())).append(" -----------------\r\n");
        builder.append("Authentication Success: ").append(remoteUser).append("\r\n");
        if (returnReq != null) {
            builder.append("Rewrite request:").append(returnReq.getUrl()).append("\r\n");
        }
        builder.append("------------------------------------------------------------------------------");
        logger.info(builder.toString());
        if (returnReq == null) {
            Render.renderJson((Object)new ApiResult(ApiStatus.OK, "\u767b\u5f55\u6210\u529f", authentication.getPrincipal()), (HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            String rewriteUrl = null;
            try {
                URIBuilder rewriteUri = new URIBuilder(this.properties.getApplicationAddress() + "/api/security/rewrite");
                rewriteUri.addParameter("token", request.getParameter("token"));
                rewriteUrl = rewriteUri.build().toString();
            }
            catch (Exception ex) {
                throw new ServletException("Can not build rewrite url", (Throwable)ex);
            }
            response.sendRedirect(rewriteUrl);
        }
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        StringBuilder builder = new StringBuilder("Authentication report -------------- ").append(sdf.get().format(new Date())).append(" -----------------\r\n");
        builder.append("Authentication Failure").append("\r\n");
        builder.append("------------------------------------------------------------------------------");
        logger.info(builder.toString());
        Render.renderJson((Object)ApiResult.failure((ApiStatus)ApiStatus.UNAUTHORIZED, (String)exception.getMessage(), (String[])new String[0]), (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider(new AuthenticationProvider(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                StringBuilder builder = new StringBuilder("Authentication report -------------- ").append(((SimpleDateFormat)sdf.get()).format(new Date())).append(" -----------------\r\n");
                builder.append("Authentication: ").append("\r\n");
                builder.append("auth_code: ").append(authentication.getCredentials()).append("\r\n");
                builder.append("------------------------------------------------------------------------------");
                logger.info(builder.toString());
                if (authentication.isAuthenticated()) {
                    return authentication;
                }
                try {
                    Token token = (Token)Token.dao.findById(authentication.getCredentials());
                    Token.dao.deleteById(authentication.getCredentials());
                    if (token == null) {
                        throw new BadCredentialsException("\u8ba4\u8bc1\u5931\u8d25");
                    }
                    if (StrKit.isBlank((String)token.getStr("USER_CODE"))) {
                        throw new BadCredentialsException("\u672a\u767b\u5f55");
                    }
                    ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
                    grantedAuthorities.add(new SimpleGrantedAuthority("USER"));
                    UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)token.getStr("USER_CODE"), authentication.getCredentials(), grantedAuthorities);
                    return result;
                }
                catch (Exception ex) {
                    logger.error("SSO\u8bc1\u9a8c\u5f02\u5e38", (Throwable)ex);
                    throw new DisabledException("SSO\u4e0d\u53ef\u7528", (Throwable)ex);
                }
            }

            public boolean supports(Class<?> authentication) {
                return UsernamePasswordAuthenticationToken.class.equals(authentication);
            }
        });
    }
}

