package cn.yerl.android.promise.http;

import com.loopj.android.http.ResponseHandlerInterface;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;

import cz.msebera.android.httpclient.Header;
import cz.msebera.android.httpclient.HttpEntity;
import cz.msebera.android.httpclient.MethodNotSupportedException;
import cz.msebera.android.httpclient.client.methods.HttpEntityEnclosingRequestBase;
import cz.msebera.android.httpclient.client.methods.HttpPost;
import cz.msebera.android.httpclient.client.methods.HttpPut;
import cz.msebera.android.httpclient.client.methods.HttpUriRequest;

/**
 * Created by alan on 2017/4/17.
 */

public class PromiseBodyRequest extends PromiseRequest {
    public PromiseBodyRequest(String url, Method method){
        super(url, method);
    }
    // ======================== body param ========================
    /**
     * 添加一个Body参数
     * @param key 参数名
     * @param value 参数值
     * @return PromiseRequest
     */
    public PromiseRequest withBodyParam(String key, Object value){
        this.bodyParams.put(key, value);
        return this;
    }
    /**
     * 添加多个Body参数
     * @param bodyParams 参数键值对
     * @return PromiseRequest
     */
    public PromiseRequest withBodyParams(Map<String, Object> bodyParams){
        this.bodyParams.putAll(bodyParams);
        return this;
    }

    /**
     * 移除Body参数
     * @param keys 参数key
     * @return PromiseRequest
     */
    public PromiseRequest removeBodyParam(String... keys){
        for (String key : keys){
            this.bodyParams.remove(key);
        }
        return this;
    }

    /**
     * 清除所有Body参数
     * @return PromiseRequest
     */
    public PromiseRequest clearBodeParams(){
        this.bodyParams.clear();
        return this;
    }
    // ======================== body param ========================

    // ======================== raw body ========================
    /**
     * Raw Body
     * @param body raw
     * @return PromiseRequest
     */
    public PromiseRequest withRawBody(String body){
        this.rawBody = body;
        return this;
    }
    /**
     * 获取 Raw Body
     * @return Raw Body
     */
    public String getRawBody(){
        return this.rawBody;
    }

    /**
     * 清除 Raw Body
     * @return PromiseRequest
     */
    public PromiseRequest removeRawBody(){
        this.rawBody = null;
        return this;
    }
    // ======================== raw body ========================


    // ======================== binary body ========================
    /**
     * Binary Body
     * @return PromiseRequest
     */
    public PromiseRequest withBinaryBody(byte[] body){
        this.binaryBody = body;
        return this;
    }
    /**
     * 获取 Binary Body
     * @return Binary Body
     */
    public byte[] getBinaryBody(){
        return this.binaryBody;
    }

    /**
     * 清除 Binary Body
     * @return PromiseRequest
     */
    public PromiseRequest removeBinaryBody(){
        this.binaryBody = null;
        return this;
    }

    // ======================== binary body ========================

    @Override
    protected HttpUriRequest getRequest(PromiseHttp http, ResponseHandlerInterface handler){
        // 处理URL，将QueryParam拼接在url后
        URI requestURI = ProcessUtils.processURI(http.getBaseUrl(), this);

        HttpEntityEnclosingRequestBase request =  null;
        switch (this.getMethod()){
            case POST:{
                request = new HttpPost(requestURI);
                break;
            }
            case PUT:{
                request = new HttpPut(requestURI);
                break;
            }
            default:{
            }
        }

        // 处理参数
        HttpEntity entity = ProcessUtils.processParams(this, handler);
        request.setEntity(entity);

        // 处理Header
        Header[] headers = ProcessUtils.processHeader(http.getSharedHeaders(), this.getHeaders());
        request.setHeaders(headers);
        return request;
    }
}
