/*
 * Decompiled with CFR 0.152.
 */
package com.yanyv.bilisdk.util;

import java.security.SecureRandom;
import java.util.Random;

public final class NanoIdUtil {
    public static final SecureRandom DEFAULT_NUMBER_GENERATOR = new SecureRandom();
    public static final char[] DEFAULT_ALPHABET = "_-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final int DEFAULT_SIZE = 21;

    private NanoIdUtil() {
    }

    public static String randomNanoId() {
        return NanoIdUtil.randomNanoId(DEFAULT_NUMBER_GENERATOR, DEFAULT_ALPHABET, 21);
    }

    public static String randomNanoId(Random random, char[] alphabet, int size) {
        if (random == null) {
            throw new IllegalArgumentException("\u968f\u673a\u7c7b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (alphabet == null) {
            throw new IllegalArgumentException("\u5b57\u7b26\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (alphabet.length != 0 && alphabet.length < 256) {
            if (size <= 0) {
                throw new IllegalArgumentException("\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0");
            }
            int mask = (2 << (int)Math.floor(Math.log(alphabet.length - 1) / Math.log(2.0))) - 1;
            int step = (int)Math.ceil(1.6 * (double)mask * (double)size / (double)alphabet.length);
            StringBuilder idBuilder = new StringBuilder();
            block0: while (true) {
                byte[] bytes = new byte[step];
                random.nextBytes(bytes);
                int i = 0;
                while (true) {
                    if (i >= step) continue block0;
                    int alphabetIndex = bytes[i] & mask;
                    if (alphabetIndex < alphabet.length) {
                        idBuilder.append(alphabet[alphabetIndex]);
                        if (idBuilder.length() == size) {
                            return idBuilder.toString();
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        throw new IllegalArgumentException("\u5b57\u7b26\u96c6\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e256");
    }
}

