/*
 * Decompiled with CFR 0.152.
 */
package com.yanyv.bilisdk.util;

import com.alibaba.fastjson.JSONObject;
import com.yanyv.bilisdk.BiliConfig;
import com.yanyv.bilisdk.util.HttpUtil;
import com.yanyv.bilisdk.util.NanoIdUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public final class BiliUtil {
    private static final String biliUrl = "https://live-open.biliapi.com/";
    private static final String waitSignTemplate = "x-bili-accesskeyid:${accessKeyId}\nx-bili-content-md5:${contentMd5}\nx-bili-signature-method:HMAC-SHA256\nx-bili-signature-nonce:${signatureNonce}\nx-bili-signature-version:1.0\nx-bili-timestamp:${timestamp}";
    private static final String accept = "Accept:application/json\n";
    private static final String contentType = "Content-Type:application/json\n";
    private static final String authorization = "Authorization:${authorization}";
    private static String accessKeyId;
    private static String accessKeySecret;

    public static JSONObject post(String uri, JSONObject data) {
        String header = BiliUtil.getBiliHeader(data.toString());
        String[] headerList = header.split("\n");
        String[][] headerArray = new String[headerList.length][2];
        for (int i = 0; i < headerList.length; ++i) {
            String[] headerItem = headerList[i].split(":");
            headerArray[i][0] = headerItem[0];
            headerArray[i][1] = headerItem[1];
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        for (String[] strings : headerArray) {
            headers.add(new BasicHeader(strings[0], strings[1]));
        }
        return HttpUtil.doPost(biliUrl + uri, headers.toArray(new Header[0]), data);
    }

    public static String getBiliWaitSign(String content) {
        String contentMd5 = DigestUtils.md5Hex((String)content);
        String signatureNonce = NanoIdUtil.randomNanoId();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put("accessKeyId", accessKeyId);
        prop.put("contentMd5", contentMd5);
        prop.put("signatureNonce", signatureNonce);
        prop.put("timestamp", timestamp);
        return BiliUtil.replaceVariable(waitSignTemplate, prop);
    }

    public static String getBiliHeader(String content) {
        String waitSign = BiliUtil.getBiliWaitSign(content);
        String signed = BiliUtil.sign(waitSign, accessKeySecret);
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put("authorization", signed);
        StringBuilder sb = new StringBuilder();
        sb.append(accept);
        sb.append(contentType);
        sb.append(waitSign);
        sb.append("\n");
        sb.append(BiliUtil.replaceVariable(authorization, prop));
        return sb.toString();
    }

    public static String replaceVariable(String template, Map<String, Object> properties) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = Pattern.compile("\\$\\{[\\.\\$\\w]+}").matcher(template);
        while (matcher.find()) {
            String param = matcher.group();
            String varible = param.substring(2, param.length() - 1);
            Object value = properties.get(varible);
            matcher.appendReplacement(sb, value == null ? "" : String.valueOf(value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String sign(String data, String key) {
        Mac sha256_HMAC = null;
        try {
            sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] array = sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte item : array) {
                sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            System.err.println("\u65e0\u6548\u7684\u5bc6\u5319" + key);
            e.printStackTrace();
        }
        return null;
    }

    public static void init(BiliConfig config) {
        accessKeyId = config.getAccessKeyId();
        accessKeySecret = config.getAccessKeySecret();
    }
}

