/*
 * Decompiled with CFR 0.152.
 */
package com.yanyv.bilisdk.manager;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class ConfigManager {
    private static ConfigManager instance = null;
    private static final String configPath = "data/config.json";
    private final JSONObject config;

    private ConfigManager() {
        this.config = new JSONObject();
        this.setDownLoadPath("data/head/");
        this.setUsersData(new JSONObject());
    }

    public ConfigManager(JSONObject config) {
        this.config = config;
    }

    public String getDownLoadPath() {
        return this.config.getString("downloadPath");
    }

    public void setDownLoadPath(String path) {
        this.config.put("downloadPath", (Object)path);
    }

    private void setUsersData(JSONObject data) {
        this.config.put("usersData", (Object)data);
    }

    public JSONObject getUsersData() {
        return this.config.getJSONObject("usersData");
    }

    private static ConfigManager createConfig() {
        ConfigManager config = new ConfigManager();
        ConfigManager.saveConfig(config);
        return config;
    }

    public static void saveConfig(ConfigManager configManager) {
        File file = new File(configPath);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file.getPath(), true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
            BufferedWriter out = new BufferedWriter(outputStreamWriter);
            FileWriter fileWriter = new FileWriter(file.getPath());
            fileWriter.write("");
            fileWriter.flush();
            fileWriter.close();
            out.write(configManager.config.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ConfigManager loadConfig() {
        File file = new File(configPath);
        if (!file.exists()) {
            try {
                File dir = new File(file.getParent());
                if (!dir.exists()) {
                    boolean bl = dir.mkdirs();
                }
                if (file.createNewFile()) {
                    return ConfigManager.createConfig();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(configPath);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            BufferedReader in = new BufferedReader(inputStreamReader);
            String str = in.readLine();
            if (str != null) {
                in.close();
                inputStreamReader.close();
                fileInputStream.close();
                return new ConfigManager(JSONObject.parseObject((String)str));
            }
            in.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ConfigManager();
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = ConfigManager.loadConfig();
        }
        return instance;
    }
}

