/*
 * Decompiled with CFR 0.152.
 */
package com.yanyv.bilisdk.listener;

import com.alibaba.fastjson.JSONObject;
import com.yanyv.bilisdk.BiliLive;
import com.yanyv.bilisdk.listener.LiveAdapter;
import com.yanyv.bilisdk.manager.HeadManager;
import com.yanyv.bilisdk.manager.UserDataManager;
import com.yanyv.bilisdk.vo.BiliUser;

public class SystemLiveListener
extends LiveAdapter {
    public SystemLiveListener(BiliLive biliLive) {
        super(biliLive);
    }

    @Override
    public void onReceivedComment(Long uid, String userName, String face, String commentText, JSONObject rawData) {
        this.updateUserInfo(uid, userName, face);
    }

    @Override
    public void onReceivedGift(Long uid, String userName, String face, Long giftId, String giftName, Long giftNum, Long price, Boolean paid, JSONObject rawData) {
        this.updateUserInfo(uid, userName, face);
    }

    public void updateUserInfo(Long uid, String userName, String face) {
        if (!this.getBiliLive().getUserMap().containsKey(uid)) {
            BiliUser biliUser = UserDataManager.isUserExist(uid) ? UserDataManager.getUser(uid) : new BiliUser();
            biliUser.setUid(uid);
            biliUser.setUserName(userName);
            biliUser.setFace(face);
            this.getBiliLive().getUserMap().put(uid, biliUser);
            UserDataManager.setUserData(biliUser);
        } else {
            BiliUser biliUser = this.getBiliLive().getUserMap().get(uid);
            if (!face.equals(biliUser.getFace())) {
                biliUser.setFace(face);
                UserDataManager.setUserData(biliUser);
            }
        }
        HeadManager.downloadHead(this.getBiliLive(), uid, face);
    }
}

