/*
 * Decompiled with CFR 0.152.
 */
package com.yanyv.bilisdk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yanyv.bilisdk.listener.LiveListener;
import com.yanyv.bilisdk.vo.BiliUser;
import java.util.List;

public class UnknownCommentController {
    public static void dispatch(JSONObject json, List<LiveListener> listeners) {
        String cmd = json.getString("cmd");
        JSONObject data = json.getJSONObject("data");
        switch (cmd) {
            case "ONLINE_RANK_COUNT": {
                Integer online = data.getInteger("count");
                for (LiveListener listener : listeners) {
                    listener.onReceivedOnlineRankCount(online);
                }
                break;
            }
            case "ONLINE_RANK_V2": {
                String rankType;
                switch (rankType = data.getString("rank_type")) {
                    case "gold-rank": {
                        JSONArray goldRank = data.getJSONArray("list");
                        List goldBiliUsers = JSONArray.parseArray((String)goldRank.toJSONString(), BiliUser.class);
                        for (LiveListener listener : listeners) {
                            listener.onReceivedOnlineRankGold(goldBiliUsers);
                        }
                        break;
                    }
                }
                break;
            }
            case "HOT_RANK_CHANGED_V2": {
                for (LiveListener listener : listeners) {
                    listener.onHotRankChangedV2(data.getString("area_name"), data.getInteger("trend"), data.getInteger("rank"));
                }
                break;
            }
            case "HOT_RANK_CHANGED": {
                for (LiveListener listener : listeners) {
                    listener.onHotRankChanged(data.getString("area_name"), data.getInteger("trend"), data.getInteger("rank"));
                }
                break;
            }
            case "HOT_RANK_SETTLEMENT_V2": {
                for (LiveListener listener : listeners) {
                    listener.onHotRankSettlementV2(data.getString("area_name"), data.getInteger("rank"));
                }
                break;
            }
            case "HOT_RANK_SETTLEMENT": {
                for (LiveListener listener : listeners) {
                    listener.onHotRankSettlement(data.getString("area_name"), data.getInteger("rank"));
                }
                break;
            }
            case "LIVE_INTERACTIVE_GAME": {
                for (LiveListener listener : listeners) {
                    listener.onLiveInteractiveGame(data.getLong("uid"), data.getString("uname"), data.getString("uface"), data.getInteger("gift_id"), data.getString("gift_name"), data.getInteger("gift_num"), data.getInteger("price"));
                }
                break;
            }
            case "COMBO_SEND": {
                for (LiveListener listener : listeners) {
                    listener.onComboSend(data.getLong("uid"), data.getString("uname"), data.getString("action"), data.getInteger("gift_id"), data.getString("gift_name"), data.getInteger("combo_num"));
                }
                break;
            }
            case "ONLINE_RANK_TOP3": {
                break;
            }
            case "STOP_LIVE_ROOM_LIST": {
                break;
            }
            default: {
                System.out.println("\u672a\u77e5\u6d88\u606f\uff1a" + json.toJSONString());
            }
        }
    }
}

