/*
 * Decompiled with CFR 0.152.
 */
package com.yanyv.bilisdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketListener;
import com.yanyv.bilisdk.BiliConfig;
import com.yanyv.bilisdk.listener.LiveListener;
import com.yanyv.bilisdk.listener.SystemLiveListener;
import com.yanyv.bilisdk.util.BiliUtil;
import com.yanyv.bilisdk.vo.BiliUser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BiliLive {
    private static BiliLive biliLive = null;
    private final List<LiveListener> listeners = new ArrayList<LiveListener>();
    private final Map<Long, BiliUser> userMap = new HashMap<Long, BiliUser>();
    private BiliConfig biliConfig;
    private boolean connecting = false;
    private String gameId = "";
    private String authBody = "";
    private WebSocket ws = null;

    private BiliLive(BiliConfig config) {
        this.biliConfig = config;
        this.addListener(new SystemLiveListener(this));
    }

    public void addListener(LiveListener listener) {
        this.listeners.add(listener);
    }

    public void connect() {
        BiliUtil.init(this.biliConfig);
        JSONObject input = new JSONObject();
        input.put("code", (Object)this.biliConfig.getCode());
        input.put("app_id", (Object)this.biliConfig.getAppid());
        System.out.println("[BiliLive]\u6b63\u5728\u5c1d\u8bd5\u8fde\u63a5\u5230\u54d4\u54e9\u54d4\u54e9\u4e16\u754c..." + input);
        JSONObject result = BiliUtil.post("v2/app/start", input);
        if (result.isEmpty()) {
            System.out.println("[BiliLive]\u8fde\u63a5\u5931\u8d25..." + result);
            return;
        }
        System.out.println("[BiliLive]\u5df2\u6210\u529f\u8fde\u63a5\u5230\u54d4\u54e9\u54d4\u54e9\u4e16\u754c..." + result);
        this.gameId = result.getJSONObject("data").getJSONObject("game_info").getString("game_id");
        this.authBody = result.getJSONObject("data").getJSONObject("websocket_info").getString("auth_body");
        this.connecting = true;
        WebSocketFactory factory = new WebSocketFactory();
        try {
            this.ws = factory.createSocket(result.getJSONObject("data").getJSONObject("websocket_info").getJSONArray("wss_link").getString(0));
            this.ws.addListener((WebSocketListener)new WebSocketAdapter(){

                public void onBinaryMessage(WebSocket websocket, byte[] binary) {
                    switch (binary[11]) {
                        case 3: {
                            System.out.println("[BiliLive-wss]\u5f39\u5e55\u5a18\u6536\u5230\u4e86\u4f60\u7684\u5c0f\u5fc3\u5fc3\u5e76\u8e22\u4e86\u4f60\u4e00jio");
                            break;
                        }
                        case 5: {
                            byte[] data = new byte[binary.length - 16];
                            System.arraycopy(binary, 16, data, 0, data.length);
                            BiliLive.this.receiveMessage(JSON.parseObject((String)new String(data, StandardCharsets.UTF_8)));
                            break;
                        }
                        case 8: {
                            System.out.println("[BiliLive-wss]\u5df2\u4e0e\u5f39\u5e55\u5a18\u53cb\u597d\u7684\u63e1\u624b...");
                            for (LiveListener listener : BiliLive.this.listeners) {
                                listener.onRoomConnected();
                            }
                            break;
                        }
                    }
                }

                public void onConnected(WebSocket websocket, Map<String, List<String>> headers) {
                    System.out.println("[BiliLive-wss]\u5df2\u4e0e\u5f39\u5e55\u5a18\u5728\u54d4\u54e9\u54d4\u54e9\u4e16\u754c\u4f1a\u6664...");
                    byte[] body = BiliLive.this.authBody.getBytes(StandardCharsets.UTF_8);
                    int pkgLength = body.length + 16;
                    byte[] pkgData = new byte[pkgLength];
                    pkgData[0] = 0;
                    pkgData[1] = 0;
                    pkgData[2] = (byte)(pkgLength / 255);
                    pkgData[3] = (byte)(pkgLength % 255);
                    pkgData[4] = 0;
                    pkgData[5] = 16;
                    pkgData[6] = 0;
                    pkgData[7] = 0;
                    pkgData[8] = 0;
                    pkgData[9] = 0;
                    pkgData[10] = 0;
                    pkgData[11] = 7;
                    pkgData[12] = 0;
                    pkgData[13] = 0;
                    pkgData[14] = 0;
                    pkgData[15] = 0;
                    System.arraycopy(body, 0, pkgData, 16, body.length);
                    System.out.println("[BiliLive-wss]\u51c6\u5907\u4e0e\u5f39\u5e55\u5a18\u8fdb\u884c\u53cb\u597d\u7684\u63e1\u624b...");
                    websocket.sendBinary(pkgData);
                }
            });
            this.ws.connect();
        }
        catch (WebSocketException | IOException e) {
            System.out.println("[BiliLive]\u8fde\u63a5\u5931\u8d25..." + result.getJSONObject("data").getJSONObject("websocket_info").getJSONArray("wss_link").getString(0));
            e.printStackTrace();
            return;
        }
        new Thread(() -> {
            while (this.connecting) {
                try {
                    Thread.sleep(20000L);
                    if (!this.connecting) break;
                    JSONObject input2 = new JSONObject();
                    input2.put("game_id", (Object)this.gameId);
                    System.out.println("[BiliLive]\u6b63\u5728\u5411\u54d4\u54e9\u54d4\u54e9\u4e16\u754c\u53d1\u9001\u4f8b\u884c\u901a\u544a..." + input2);
                    JSONObject result2 = BiliUtil.post("v2/app/heartbeat", input2);
                    System.out.println("[BiliLive]\u901a\u544a\u7ed3\u679c..." + result2);
                    byte[] pkgData = new byte[]{0, 0, 0, 16, 0, 16, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0};
                    System.out.println("[BiliLive-wss]\u6b63\u5728\u5411\u5f39\u5e55\u5a18\u53d1\u5c04\u5c0f\u5fc3\u5fc3...");
                    this.ws.sendBinary(pkgData);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void disconnect() {
        this.connecting = false;
        JSONObject input = new JSONObject();
        input.put("game_id", (Object)this.gameId);
        input.put("app_id", (Object)this.biliConfig.getAppid());
        System.out.println("[BiliLive]\u6b63\u5728\u65ad\u5f00\u4e0e\u54d4\u54e9\u54d4\u54e9\u4e16\u754c\u7684\u8fde\u63a5..." + input);
        JSONObject result = BiliUtil.post("v2/app/end", input);
        System.out.println("[BiliLive-wss]\u6b63\u5728\u4e0e\u5f39\u5e55\u5a18\u6325\u624b...");
        this.ws.disconnect();
        for (LiveListener listener : this.listeners) {
            listener.onRoomDisconnected();
        }
        System.out.println("[BiliLive]\u5df2\u6210\u529f\u65ad\u5f00\u8fde\u63a5..." + result);
    }

    private void receiveMessage(JSONObject obj) {
        String cmd = obj.getString("cmd");
        obj = obj.getJSONObject("data");
        switch (cmd) {
            case "LIVE_OPEN_PLATFORM_DM": {
                for (LiveListener listener : this.listeners) {
                    listener.onReceivedComment(obj.getLong("uid"), obj.getString("uname"), obj.getString("uface"), obj.getString("msg"), obj);
                }
                break;
            }
            case "LIVE_OPEN_PLATFORM_SEND_GIFT": {
                for (LiveListener listener : this.listeners) {
                    listener.onReceivedGift(obj.getLong("uid"), obj.getString("uname"), obj.getString("uface"), obj.getLong("gift_id"), obj.getString("gift_name"), obj.getLong("gift_num"), obj.getLong("price"), obj.getBoolean("paid"), obj);
                }
                break;
            }
            case "LIVE_OPEN_PLATFORM_GUARD": {
                for (LiveListener listener : this.listeners) {
                    listener.onReceivedGuardBuy(obj.getJSONObject("user_info").getLong("uid"), obj.getJSONObject("user_info").getString("uname"), obj.getLong("guard_level"), obj.getLong("guard_num"), obj.getString("guard_unit"), obj);
                }
                break;
            }
            case "LIVE_OPEN_PLATFORM_SUPER_CHAT": {
                for (LiveListener listener : this.listeners) {
                    listener.onReceivedSuperChat(obj.getLong("uid"), obj.getString("uname"), obj.getString("message"), obj.getLong("rmb"), obj);
                }
                break;
            }
            default: {
                System.out.println("[BiliLive-wss]\u672a\u77e5\u6d88\u606f" + obj);
            }
        }
    }

    public Map<Long, BiliUser> getUserMap() {
        return this.userMap;
    }

    public static BiliLive getInstance(BiliConfig config) {
        if (biliLive == null) {
            biliLive = new BiliLive(config);
        }
        return biliLive;
    }
}

