/*
 * Decompiled with CFR 0.152.
 */
package cn.yang37.entity;

import java.util.HashMap;
import java.util.Map;

public class ThreadContext {
    private static final ThreadLocal<Map<String, Object>> CTX_HOLDER = new ThreadLocal();
    private static final String TRACE_ID_KEY = "traceId";

    public static void init() {
        CTX_HOLDER.set(new HashMap());
    }

    public static void clean() {
        CTX_HOLDER.remove();
    }

    public static Map<String, Object> getContext() {
        return CTX_HOLDER.get();
    }

    public static void putContext(String key, Object value) {
        Map<String, Object> ctx = CTX_HOLDER.get();
        if (ctx == null) {
            return;
        }
        ctx.put(key, value);
    }

    public static <T> T getContext(String key) {
        Map<String, Object> ctx = CTX_HOLDER.get();
        if (ctx == null) {
            return null;
        }
        return (T)ctx.get(key);
    }

    public static void remove(String key) {
        Map<String, Object> ctx = CTX_HOLDER.get();
        if (ctx != null) {
            ctx.remove(key);
        }
    }

    public static boolean contains(String key) {
        Map<String, Object> ctx = CTX_HOLDER.get();
        if (ctx != null) {
            return ctx.containsKey(key);
        }
        return false;
    }

    public static void putTraceId(String traceId) {
        ThreadContext.putContext(TRACE_ID_KEY, traceId);
    }

    public static String getTraceId() {
        return (String)ThreadContext.getContext(TRACE_ID_KEY);
    }

    static {
        CTX_HOLDER.set(new HashMap());
    }
}

