/*
 * Decompiled with CFR 0.152.
 */
package cn.yang37.app.impl;

import cn.yang37.app.SendMessageService;
import cn.yang37.entity.context.MessageContext;
import cn.yang37.entity.message.Message;
import cn.yang37.exception.ExecuteException;
import cn.yang37.factory.MessageServiceFactory;
import cn.yang37.service.AbstractMessageService;
import cn.yang37.util.GsonUtils;
import cn.yang37.util.MessageProvider;
import cn.yang37.util.TraceUtils;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageServiceImpl
extends MessageProvider
implements SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageServiceImpl.class);

    @Override
    public MessageContext singleSend(Message message) {
        MessageContext messageContext = MessageContext.builder().build();
        try {
            messageContext = this.message2MessageContext(message);
            SendMessageServiceImpl.formatTraceId(messageContext);
            log.debug("message: {},messageContext: {}", (Object)GsonUtils.toJson((Object)message), (Object)GsonUtils.toJson((Object)messageContext));
            AbstractMessageService messageService = MessageServiceFactory.instance().getMessageService(messageContext.getMessageSceneType());
            if (ObjectUtils.isEmpty((Object)messageService)) {
                throw new ExecuteException("\u65e0\u6cd5\u67e5\u627e\u5230\u5b9e\u4f53\u7c7b\u5bf9\u5e94\u7684\u6d88\u606f\u670d\u52a1!");
            }
            return messageService.singleSend(messageContext);
        }
        catch (Exception e) {
            messageContext.setState(Boolean.valueOf(false));
            log.error("easy-push\u6d88\u606f\u53d1\u9001\u5f02\u5e38!", (Throwable)e);
            return messageContext;
        }
    }

    @Override
    public List<MessageContext> multipleSend(List<Message> messageList) {
        return null;
    }

    private static void formatTraceId(MessageContext messageContext) {
        TraceUtils.traceStart((String)messageContext.getId(), (String)messageContext.getMessageSceneType().name());
    }
}

