/*
 * Decompiled with CFR 0.152.
 */
package cn.yang37.app.impl;

import cn.yang37.app.SendMessageService;
import cn.yang37.entity.Message;
import cn.yang37.entity.MessageContext;
import cn.yang37.enums.MessageSceneType;
import cn.yang37.factory.MessageServiceStrategyFactory;
import cn.yang37.service.execute.AbstractMessageService;
import cn.yang37.strategy.service.ProxyMessageServiceStrategy;
import cn.yang37.util.GsonUtils;
import cn.yang37.util.MessageProvider;
import cn.yang37.util.TraceUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageServiceImpl
extends MessageProvider
implements SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageServiceImpl.class);

    @Override
    public MessageContext singleSend(Message message) {
        MessageContext messageContext = MessageContext.builder().build();
        try {
            messageContext = this.message2MessageContext(message);
            SendMessageServiceImpl.formatTraceId(messageContext);
            log.debug("message: {},messageContext: {}", (Object)GsonUtils.toJson((Object)message), (Object)GsonUtils.toJson((Object)messageContext));
            AbstractMessageService messageService = SendMessageServiceImpl.parseMessageService(messageContext.getMessageSceneType());
            return messageService.singleSend(messageContext);
        }
        catch (Exception e) {
            log.error("[easy-push] error!!!", (Throwable)e);
            return messageContext;
        }
    }

    private static void formatTraceId(MessageContext messageContext) {
        TraceUtils.traceStart((String)messageContext.getId(), (String)messageContext.getMessageSceneType().name());
    }

    @Override
    public List<MessageContext> multipleSend(List<Message> messageList) {
        return null;
    }

    private static AbstractMessageService parseMessageService(MessageSceneType messageSceneType) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        AbstractMessageService messageService = MessageServiceStrategyFactory.instance().obtainMessageServiceStrategy(ProxyMessageServiceStrategy.class).getMessageService(messageSceneType);
        log.debug("[MessageSceneTyp<->{}] parse messageService: {}", (Object)messageSceneType, (Object)messageService);
        return messageService;
    }
}

