/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.utils;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("(\\d*)(\\.?)(\\d*)");
        Matcher isNum = pattern.matcher(str);
        if (!isNum.matches()) {
            return false;
        }
        String group = isNum.group(2);
        String group1 = isNum.group(3);
        return !StringUtils.isNotBlank(group) || !StringUtils.isBlank(group1);
    }

    public static boolean isIntegerNumeric(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("(\\d+)(\\.{1})(\\d*)");
        Matcher isNum = pattern.matcher(str);
        if (!isNum.matches()) {
            BigInteger bigDecimal = new BigInteger(str);
            return Integer.MIN_VALUE <= bigDecimal.longValue() && bigDecimal.longValue() <= Integer.MAX_VALUE;
        }
        return false;
    }

    public static boolean isBoolean(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("true|false");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

