/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.utils;

import cn.xxywithpq.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class ReflectionUtils {
    private static final int ACCESS_MODIFIERS = 7;
    private static Logger logger = Logger.getLogger(ReflectionUtils.class.getName());

    private ReflectionUtils() {
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtils.getDeclaredField(object.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
        }
        ReflectionUtils.makeAccessible(field);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.severe("ReflectionUtils getFieldValue : " + e.getMessage());
            return result;
        }
        return result;
    }

    public static Object getFieldValue(Field field, Object object) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be empty");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be empty");
        }
        ReflectionUtils.makeAccessible(field);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.severe("ReflectionUtils getFieldValue : " + e.getMessage());
            return result;
        }
        return result;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
        }
        ReflectionUtils.makeAccessible(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            logger.severe("ReflectionUtils setFieldValue : " + e.getMessage());
        }
    }

    protected static Field getDeclaredField(Object object, String fieldName) {
        if (Objects.isNull(object)) {
            throw new IllegalArgumentException("The object cannot be empty");
        }
        return ReflectionUtils.getDeclaredField(object.getClass(), fieldName);
    }

    public static Field getValueFromDeclaredMethods(Class clazz) {
        if (Objects.isNull(clazz)) {
            throw new IllegalArgumentException("The clazz cannot be empty");
        }
        Method[] declaredMethods = clazz.getMethods();
        if (null != declaredMethods && declaredMethods.length > 0) {
            for (Method method : declaredMethods) {
                System.out.println(method.getName() + "  :  " + ReflectionUtils.getModifier(method));
            }
        }
        return null;
    }

    public static String getModifier(Method m) {
        return ReflectionUtils.getModifier(Modifier.methodModifiers(), m.getModifiers(), m.isDefault());
    }

    static String getModifier(int mask, int modifiers, boolean isDefault) {
        int mod = modifiers & mask;
        if (mod != 0 && !isDefault) {
            return Modifier.toString(mod);
        }
        int access_mod = mod & 7;
        if (access_mod != 0) {
            return Modifier.toString(access_mod);
        }
        if (isDefault) {
            return "default ";
        }
        if ((mod &= 0xFFFFFFF8) != 0) {
            return Modifier.toString(mod);
        }
        return null;
    }

    protected static Field getDeclaredField(Class clazz, String fieldName) {
        if (Objects.isNull(clazz)) {
            throw new IllegalArgumentException("The clazz cannot be empty");
        }
        if (StringUtils.isEmpty(fieldName)) {
            throw new IllegalArgumentException("this String argument must have text; it must not be null, empty, or blank");
        }
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static List<Method> getAllDeclaredMethods(Class clazz) {
        if (Objects.isNull(clazz)) {
            throw new IllegalArgumentException("The clazz cannot be empty");
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            Method[] declaredMethods = superClass.getDeclaredMethods();
            if (null == declaredMethods || declaredMethods.length <= 0) continue;
            for (Method m : declaredMethods) {
                methods.add(m);
            }
        }
        return methods;
    }

    protected static void makeAccessible(Field field) {
    }

    public static Class getSuperClassGenricType(Class clazz) {
        return ReflectionUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warning(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warning("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warning(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static List fetchElementPropertyToList(Collection collection, String propertyName) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : collection) {
            list.add(ReflectionUtils.getFieldValue(obj, propertyName));
        }
        return list;
    }

    public static Type[] getActualTypeArguments(Type t) {
        if (ParameterizedType.class.isAssignableFrom(t.getClass())) {
            return ((ParameterizedType)t).getActualTypeArguments();
        }
        return null;
    }
}

