/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.utils;

import cn.xxywithpq.proxy.asmproxy.asm.Opcodes;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;

public class ASMEngineTools
implements Opcodes {
    public static int getReturn(String asmType) {
        char t = asmType.charAt(0);
        switch (t) {
            case 'B': {
                return 172;
            }
            case 'C': {
                return 172;
            }
            case 'D': {
                return 175;
            }
            case 'F': {
                return 174;
            }
            case 'I': {
                return 172;
            }
            case 'J': {
                return 173;
            }
            case 'L': {
                return 176;
            }
            case 'S': {
                return 172;
            }
            case 'Z': {
                return 172;
            }
            case '[': {
                return 176;
            }
            case 'V': {
                return 177;
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u88c5\u8f7d\u8bf7\u6c42");
    }

    public static int getLoad(String asmType) {
        char t = asmType.charAt(0);
        switch (t) {
            case 'B': {
                return 21;
            }
            case 'C': {
                return 21;
            }
            case 'D': {
                return 24;
            }
            case 'F': {
                return 23;
            }
            case 'I': {
                return 21;
            }
            case 'J': {
                return 22;
            }
            case 'L': {
                return 25;
            }
            case 'S': {
                return 21;
            }
            case 'Z': {
                return 21;
            }
            case '[': {
                return 25;
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u88c5\u8f7d\u8bf7\u6c42");
    }

    public static int getAstore(String asmType) {
        char t = asmType.charAt(0);
        switch (t) {
            case 'B': {
                return 79;
            }
            case 'C': {
                return 79;
            }
            case 'D': {
                return 82;
            }
            case 'F': {
                return 81;
            }
            case 'I': {
                return 79;
            }
            case 'J': {
                return 80;
            }
            case 'L': {
                return 83;
            }
            case 'S': {
                return 79;
            }
            case 'Z': {
                return 79;
            }
            case '[': {
                return 83;
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u88c5\u8f7d\u8bf7\u6c42");
    }

    public static String toAsmType(Class<?> classType) {
        if (classType == Integer.TYPE) {
            return "I";
        }
        if (classType == Byte.TYPE) {
            return "B";
        }
        if (classType == Character.TYPE) {
            return "C";
        }
        if (classType == Double.TYPE) {
            return "D";
        }
        if (classType == Float.TYPE) {
            return "F";
        }
        if (classType == Long.TYPE) {
            return "J";
        }
        if (classType == Short.TYPE) {
            return "S";
        }
        if (classType == Boolean.TYPE) {
            return "Z";
        }
        if (classType == Void.TYPE) {
            return "V";
        }
        if (classType.isArray()) {
            return "[" + ASMEngineTools.toAsmType(classType.getComponentType());
        }
        return "L" + cn.xxywithpq.proxy.asmproxy.asm.Type.getInternalName(classType) + ";";
    }

    public static String toAsmType(Class<?>[] classType) {
        String returnString = "";
        for (Class<?> c : classType) {
            returnString = returnString + ASMEngineTools.toAsmType(c);
        }
        return returnString;
    }

    public static String toAsmSignature(Method targetMethod) {
        int i;
        StringBuffer signature = new StringBuffer();
        Class<?>[] pTypeArray = targetMethod.getParameterTypes();
        MoreType[] mTypeList = new MoreType[pTypeArray.length];
        for (int i2 = 0; i2 < pTypeArray.length; ++i2) {
            Class<?> pType = pTypeArray[i2];
            MoreType mtype = new MoreType();
            mtype.paramClass = pType;
            mTypeList[i2] = mtype;
        }
        Type[] gTypeArray = targetMethod.getGenericParameterTypes();
        for (int i3 = 0; i3 < gTypeArray.length; ++i3) {
            Type gType = gTypeArray[i3];
            if (!(gType instanceof TypeVariable)) continue;
            mTypeList[i3].name = ((TypeVariable)gType).getName();
            mTypeList[i3].paramType = (TypeVariable)gType;
        }
        TypeVariable<Method>[] tTypeArray = targetMethod.getTypeParameters();
        for (i = 0; i < tTypeArray.length; ++i) {
            if (i == 0) {
                signature.append("<");
            }
            TypeVariable<Method> tType = tTypeArray[i];
            String tName = tType.getName();
            for (int j = 0; j < mTypeList.length; ++j) {
                if (!tName.equals(mTypeList[j].name)) continue;
                signature.append(tName);
                if (mTypeList[j].paramClass.isInterface()) {
                    signature.append("::");
                } else {
                    signature.append(":");
                }
                for (Type atType : mTypeList[j].paramType.getBounds()) {
                    ASMEngineTools.getTypeVarStr(signature, atType);
                }
            }
            if (i != tTypeArray.length - 1) continue;
            signature.append(">");
        }
        signature.append("(");
        for (i = 0; i < mTypeList.length; ++i) {
            MoreType mType = mTypeList[i];
            if (mType.name != null) {
                signature.append(String.format("T%s;", mType.name));
                continue;
            }
            signature.append(ASMEngineTools.toAsmType(mType.paramClass));
        }
        signature.append(")");
        signature.append(ASMEngineTools.toAsmType(targetMethod.getReturnType()));
        if (signature.length() == 0) {
            return null;
        }
        return signature.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static StringBuffer getTypeVarStr(StringBuffer atString, Type type) {
        if (type instanceof TypeVariable) {
            TypeVariable paramType = (TypeVariable)type;
            atString.append("T" + paramType.getName() + ";");
            return atString;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            atString.append("L" + ASMEngineTools.replaceClassName((Class)paramType.getRawType()));
            atString.append("<");
            for (Type atType : paramType.getActualTypeArguments()) {
                ASMEngineTools.getTypeVarStr(atString, atType);
            }
            atString.append(">");
            atString.append(";");
            return atString;
        } else if (type instanceof Class) {
            Class paramType = (Class)type;
            atString.append(ASMEngineTools.toAsmType(paramType));
            return atString;
        } else if (type instanceof WildcardType) {
            WildcardType paramType = (WildcardType)type;
            Type[] upperType = paramType.getUpperBounds();
            Type[] lowerType = paramType.getLowerBounds();
            if (lowerType.length == 0 && upperType.length != 0) {
                atString.append("+");
                for (Type atType : upperType) {
                    ASMEngineTools.getTypeVarStr(atString, atType);
                }
                return atString;
            } else {
                if (lowerType.length == 0 || upperType.length == 0) throw new RuntimeException("Generic format error.");
                atString.append("-");
                for (Type atType : lowerType) {
                    ASMEngineTools.getTypeVarStr(atString, atType);
                }
            }
            return atString;
        } else if (!(type instanceof GenericArrayType)) return atString;
        return atString;
    }

    public static String toAsmFullDesc(Method method) {
        StringBuffer str = new StringBuffer();
        str.append(method.getName());
        str.append("(");
        str.append(ASMEngineTools.toAsmType(method.getParameterTypes()));
        str.append(")");
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            str.append("V");
        } else {
            str.append(ASMEngineTools.toAsmType(returnType));
        }
        return str.toString();
    }

    public static String toAsmDesc(Method method) {
        StringBuffer str = new StringBuffer();
        str.append("(");
        str.append(ASMEngineTools.toAsmType(method.getParameterTypes()));
        str.append(")");
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            str.append("V");
        } else {
            str.append(ASMEngineTools.toAsmType(returnType));
        }
        return str.toString();
    }

    public static boolean isLangClass(Class<?> type) {
        return type.getName().startsWith("java.lang.");
    }

    public static String[] splitAsmType(String asmTypes) {
        try {
            class AsmTypeRead {
                StringReader sread = null;

                public AsmTypeRead(String sr) {
                    this.sread = new StringReader(sr);
                }

                private String readToSemicolon() throws IOException {
                    String res = "";
                    int strInt;
                    while ((strInt = this.sread.read()) != -1) {
                        if ((char)strInt == ';') {
                            return res + ';';
                        }
                        res = res + (char)strInt;
                    }
                    return res;
                }

                private String readType() throws IOException {
                    int strInt = this.sread.read();
                    if (strInt == -1) {
                        return "";
                    }
                    switch ((char)strInt) {
                        case '[': {
                            return '[' + this.readType();
                        }
                        case 'L': {
                            return 'L' + this.readToSemicolon();
                        }
                    }
                    return String.valueOf((char)strInt);
                }

                public String[] readTypes() throws IOException {
                    String s;
                    ArrayList<String> ss = new ArrayList<String>(0);
                    while (!(s = this.readType()).equals("")) {
                        ss.add(s);
                    }
                    String[] res = new String[ss.size()];
                    ss.toArray(res);
                    return res;
                }
            }
            return new AsmTypeRead(asmTypes).readTypes();
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684ASM\u7c7b\u578bdesc\u3002");
        }
    }

    public static String replaceClassName(Class<?> targetClass) {
        return targetClass.getName().replace(".", "/");
    }

    public static boolean checkIn(int data, int check) {
        int or = data | check;
        return or == data;
    }

    public static boolean isBaseType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type == Boolean.class) {
            return true;
        }
        if (type == Byte.class) {
            return true;
        }
        if (type == Character.class) {
            return true;
        }
        if (type == Short.class) {
            return true;
        }
        if (type == Integer.class) {
            return true;
        }
        if (type == Long.class) {
            return true;
        }
        if (type == Float.class) {
            return true;
        }
        return type == Double.class;
    }

    public static String asmTypeToType(String asmType) {
        if (asmType.charAt(0) == 'L') {
            return asmType.substring(1, asmType.length() - 1);
        }
        return asmType;
    }

    private static class MoreType {
        public String name = null;
        public Class<?> paramClass = null;
        public TypeVariable<?> paramType = null;

        private MoreType() {
        }
    }
}

