/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.proxy.asmproxy;

import cn.xxywithpq.proxy.Proxy;
import cn.xxywithpq.proxy.asmproxy.asm.ClassVisitor;
import cn.xxywithpq.proxy.asmproxy.asm.FieldVisitor;
import cn.xxywithpq.proxy.asmproxy.asm.Label;
import cn.xxywithpq.proxy.asmproxy.asm.MethodVisitor;
import cn.xxywithpq.proxy.asmproxy.asm.Opcodes;
import cn.xxywithpq.proxy.asmproxy.asm.Type;
import cn.xxywithpq.utils.ASMEngineTools;
import java.lang.reflect.InvocationHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AopClassAdapter
extends ClassVisitor
implements Opcodes {
    public static final String AopPrefix = "$simplify";
    public static final String proxyClass = ASMEngineTools.replaceClassName(Proxy.class);
    public static final String proxyAsmClass = ASMEngineTools.toAsmType(Proxy.class);
    int ACC_PRIVATEFINAL = 18;
    private String superClassName = null;
    private String subClassName = null;
    private InvocationHandler invocationHandler = null;

    public AopClassAdapter(int api, ClassVisitor cv, InvocationHandler invocationHandler) {
        super(api, cv);
        this.invocationHandler = invocationHandler;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superClassName = name;
        this.subClassName = name + AopPrefix;
        super.visit(version, access, this.subClassName, signature, name, interfaces);
        super.visitField(2, "invocationHandler", proxyAsmClass, null, null);
        MethodVisitor mv = super.visitMethod(4, "setInvocationHandler", "(" + proxyAsmClass + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.subClassName, "invocationHandler", proxyAsmClass);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (2 != access && 16 != access && this.ACC_PRIVATEFINAL != access) {
            if ("<init>".equals(name)) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                this.visitConstruction(mv, name, desc);
            } else {
                MethodVisitor mv$simplify = super.visitMethod(access, name + AopPrefix, desc, signature, exceptions);
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                this.visitAOPMethod(mv, name, desc);
                this.visitSupperMethod(mv$simplify, name, desc);
            }
        }
        return null;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    private void visitConstruction(MethodVisitor mv, String name, String desc) {
        mv.visitCode();
        Pattern p = Pattern.compile("\\((.*)\\)(.*)");
        Matcher m = p.matcher(desc);
        m.find();
        String[] asmParams = ASMEngineTools.splitAsmType(m.group(1));
        int paramCount = asmParams.length;
        mv.visitVarInsn(25, 0);
        for (int i = 0; i < paramCount; ++i) {
            String asmType = asmParams[i];
            mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
        }
        mv.visitMethodInsn(183, this.superClassName, name, desc, false);
        mv.visitInsn(177);
        mv.visitMaxs(paramCount + 1, paramCount + 1);
        mv.visitEnd();
    }

    private void visitAOPMethod(MethodVisitor mv, String name, String desc) {
        Pattern p = Pattern.compile("\\((.*)\\)(.*)");
        Matcher m = p.matcher(desc);
        m.find();
        String[] asmParams = ASMEngineTools.splitAsmType(m.group(1));
        String asmReturns = m.group(2);
        int paramCount = asmParams.length;
        int maxStack = 8;
        int maxLocals = paramCount + 8;
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label tryCatch = new Label();
        mv.visitTryCatchBlock(tryBegin, tryEnd, tryCatch, ASMEngineTools.replaceClassName(Throwable.class));
        mv.visitLabel(tryBegin);
        this.codeBuilder_2(mv, asmParams);
        mv.visitVarInsn(58, paramCount + 2);
        this.codeBuilder_1(mv, asmParams);
        mv.visitVarInsn(58, paramCount + 3);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.subClassName, "getClass", "()Ljava/lang/Class;", false);
        mv.visitLdcInsn(name + AopPrefix);
        mv.visitVarInsn(25, paramCount + 2);
        mv.visitMethodInsn(182, ASMEngineTools.replaceClassName(Class.class), "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
        mv.visitVarInsn(58, paramCount + 4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.subClassName, "invocationHandler", proxyAsmClass);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, paramCount + 4);
        mv.visitVarInsn(25, paramCount + 3);
        mv.visitMethodInsn(182, proxyClass, "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitVarInsn(58, paramCount + 5);
        mv.visitVarInsn(25, paramCount + 5);
        this.codeBuilder_3(mv, asmReturns);
        mv.visitLabel(tryEnd);
        mv.visitLabel(tryCatch);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        mv.visitVarInsn(58, paramCount + 6);
        mv.visitTypeInsn(187, ASMEngineTools.replaceClassName(RuntimeException.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, paramCount + 6);
        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V", false);
        mv.visitInsn(191);
        mv.visitMaxs(maxStack, maxLocals);
    }

    private void visitSupperMethod(MethodVisitor mv, String name, String desc) {
        Pattern p = Pattern.compile("\\((.*)\\)(.*)");
        Matcher m = p.matcher(desc);
        m.find();
        String[] asmParams = ASMEngineTools.splitAsmType(m.group(1));
        String asmReturns = m.group(2);
        int paramCount = asmParams.length;
        mv.visitVarInsn(25, 0);
        for (int i = 0; i < paramCount; ++i) {
            String asmType = asmParams[i];
            mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
        }
        mv.visitMethodInsn(183, this.superClassName, name, desc, false);
        mv.visitInsn(ASMEngineTools.getReturn(asmReturns));
        mv.visitMaxs(paramCount + 1, paramCount + 1);
    }

    private void codeBuilder_1(MethodVisitor mv, String[] asmParams) {
        int paramCount = asmParams.length;
        mv.visitIntInsn(16, paramCount);
        mv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < paramCount; ++i) {
            String asmType = asmParams[i];
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            if (asmParams[i].equals("B")) {
                mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
            } else if (asmParams[i].equals("S")) {
                mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
            } else if (asmParams[i].equals("I")) {
                mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            } else if (asmParams[i].equals("J")) {
                mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
            } else if (asmParams[i].equals("F")) {
                mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
            } else if (asmParams[i].equals("D")) {
                mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            } else if (asmParams[i].equals("C")) {
                mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
            } else if (asmParams[i].equals("Z")) {
                mv.visitVarInsn(ASMEngineTools.getLoad(asmType), i + 1);
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
            } else {
                mv.visitVarInsn(25, i + 1);
            }
            mv.visitInsn(83);
        }
    }

    private void codeBuilder_2(MethodVisitor mv, String[] asmParams) {
        int paramCount = asmParams.length;
        mv.visitIntInsn(16, paramCount);
        mv.visitTypeInsn(189, "java/lang/Class");
        for (int i = 0; i < paramCount; ++i) {
            String asmType = asmParams[i];
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            if (asmParams[i].equals("B")) {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("S")) {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("I")) {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("J")) {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("F")) {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("D")) {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("C")) {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("Z")) {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
            } else {
                mv.visitLdcInsn(Type.getType(asmType));
            }
            mv.visitInsn(83);
        }
    }

    private void codeBuilder_3(MethodVisitor mv, String asmReturns) {
        if (asmReturns.equals("B")) {
            mv.visitTypeInsn(192, "java/lang/Byte");
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
            mv.visitInsn(ASMEngineTools.getReturn("B"));
        } else if (asmReturns.equals("S")) {
            mv.visitTypeInsn(192, "java/lang/Short");
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
            mv.visitInsn(ASMEngineTools.getReturn("S"));
        } else if (asmReturns.equals("I")) {
            mv.visitTypeInsn(192, "java/lang/Integer");
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
            mv.visitInsn(ASMEngineTools.getReturn("I"));
        } else if (asmReturns.equals("J")) {
            mv.visitTypeInsn(192, "java/lang/Long");
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
            mv.visitInsn(ASMEngineTools.getReturn("J"));
        } else if (asmReturns.equals("F")) {
            mv.visitTypeInsn(192, "java/lang/Float");
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
            mv.visitInsn(ASMEngineTools.getReturn("F"));
        } else if (asmReturns.equals("D")) {
            mv.visitTypeInsn(192, "java/lang/Double");
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
            mv.visitInsn(ASMEngineTools.getReturn("D"));
        } else if (asmReturns.equals("C")) {
            mv.visitTypeInsn(192, "java/lang/Character");
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
            mv.visitInsn(ASMEngineTools.getReturn("C"));
        } else if (asmReturns.equals("Z")) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
            mv.visitInsn(ASMEngineTools.getReturn("Z"));
        } else if (asmReturns.equals("V")) {
            mv.visitInsn(87);
            mv.visitInsn(177);
        } else {
            mv.visitTypeInsn(192, ASMEngineTools.asmTypeToType(asmReturns));
            mv.visitInsn(176);
        }
    }
}

