/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.proxy;

import cn.xxywithpq.proxy.common.Interceptor;
import cn.xxywithpq.proxy.common.Intercepts;
import cn.xxywithpq.proxy.common.Invocation;
import cn.xxywithpq.proxy.factory.ProxyFactory;
import cn.xxywithpq.proxy.factory.service.ProxyService;
import cn.xxywithpq.proxy.factory.service.impl.AsmProxyServiceImpl;
import cn.xxywithpq.proxy.factory.service.impl.JDKProxyServiceImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class Proxy
implements InvocationHandler {
    private static Logger logger = Logger.getLogger(Proxy.class.getName());
    private Object object;
    private Interceptor interceptor;
    private ArrayList<Method> interceptsList;

    public Proxy(Object object, Interceptor interceptor, ArrayList<Method> interceptsList) {
        this.object = object;
        this.interceptor = interceptor;
        this.interceptsList = interceptsList;
    }

    public static Object wrap(Object target, Interceptor interceptor) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?>[] interfaces = target.getClass().getInterfaces();
        if (null == interfaces || interfaces.length < 1) {
            return Proxy.wrap(target, interceptor, false);
        }
        return Proxy.wrap(target, interceptor, true);
    }

    public static Object wrap(Object target, Interceptor interceptor, boolean isJdkProxy) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ArrayList<Method> interceptsList = Proxy.getInterceptsList(target, interceptor);
        Proxy proxy = new Proxy(target, interceptor, interceptsList);
        if (isJdkProxy) {
            return Proxy.staticserviceConsumer(JDKProxyServiceImpl.factory, proxy, target);
        }
        return Proxy.staticserviceConsumer(AsmProxyServiceImpl.factory, proxy, target);
    }

    public static Object staticserviceConsumer(ProxyFactory proxyFactory, Proxy proxy, Object target) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ProxyService service = proxyFactory.getService();
        return service.generateAOPObject(target, proxy);
    }

    private static ArrayList<Method> getInterceptsList(Object target, Interceptor interceptor) {
        int i;
        Intercepts interceptsAnnotation = interceptor.getClass().getAnnotation(Intercepts.class);
        if (interceptsAnnotation == null) {
            throw new RuntimeException("No @Intercepts annotation was found in interceptor " + interceptor.getClass().getName());
        }
        ArrayList<Method> signatureMap = new ArrayList<Method>();
        String[] methods1 = interceptsAnnotation.methods();
        ArrayList<Method> methods2 = new ArrayList<Method>();
        Class<?>[] interfaces = target.getClass().getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            methods2.addAll(Arrays.asList(interfaces[i].getDeclaredMethods()));
        }
        methods2.addAll(Arrays.asList(target.getClass().getMethods()));
        block1: for (i = 0; i < methods1.length; ++i) {
            String methodName = methods1[i];
            for (int j = 0; j < methods2.size(); ++j) {
                if (!((Method)methods2.get(j)).getName().equals(methodName)) continue;
                signatureMap.add((Method)methods2.get(j));
                continue block1;
            }
        }
        return signatureMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int $simplify = proxy.getClass().getSimpleName().lastIndexOf("$simplify");
        if ($simplify > 0) {
            String substring = method.getName().substring(0, method.getName().lastIndexOf("$simplify"));
            ArrayList classes = new ArrayList();
            for (int i = 0; i < args.length; ++i) {
                classes.add(args[i].getClass());
            }
            Method method1 = this.object.getClass().getMethod(substring, classes.toArray(new Class[classes.size()]));
            if (null != this.interceptsList && this.interceptsList.contains(method1)) {
                return this.interceptor.intercept(new Invocation(method, args, proxy));
            }
        } else {
            return this.interceptor.intercept(new Invocation(method, args, this.object));
        }
        return method.invoke(this.object, args);
    }
}

