/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.json.parse;

import cn.xxywithpq.json.AbstractJson;
import cn.xxywithpq.json.IJson;
import cn.xxywithpq.json.JsonArray;
import cn.xxywithpq.json.JsonObject;
import cn.xxywithpq.utils.ReflectionUtils;
import cn.xxywithpq.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;

public class JsonParser
extends AbstractJson {
    private static JsonParser jsonParser = new JsonParser();

    private JsonParser() {
    }

    public static JsonParser getInstance() {
        return jsonParser;
    }

    public <T> T parseObject(String text, Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        JsonObject jsonObject = this.parseObject(text);
        return this.parseObject(jsonObject, clazz);
    }

    private <T> T parseObject(JsonObject jsonObject, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (Objects.isNull(jsonObject)) {
            return null;
        }
        T t = clazz.newInstance();
        Set keys = jsonObject.keySet();
        if (keys.size() > 0) {
            List<Method> allDeclaredMethods = ReflectionUtils.getAllDeclaredMethods(clazz);
            ArrayList<Method> publicSetMethods = new ArrayList<Method>();
            if (null != allDeclaredMethods && allDeclaredMethods.size() > 0) {
                for (Method m : allDeclaredMethods) {
                    String modifier = ReflectionUtils.getModifier(m);
                    if (!modifier.contains("public") || !m.getName().contains("set")) continue;
                    publicSetMethods.add(m);
                }
            }
            if (publicSetMethods.size() > 0) {
                for (Method m : publicSetMethods) {
                    String methodName = m.getName();
                    String variable = methodName.substring(3, methodName.length());
                    Class<?>[] parameterTypes = m.getParameterTypes();
                    Class<?> parameterType = null;
                    if (null != parameterTypes && parameterTypes.length == 1) {
                        parameterType = parameterTypes[0];
                    }
                    if (!jsonObject.containsKey(variable = variable.substring(0, 1).toLowerCase() + variable.substring(1, variable.length()))) continue;
                    Object oo = jsonObject.get(variable);
                    IJson suitableHandler = this.getSuitableHandler(parameterType);
                    Object parse = suitableHandler.parse(oo, m);
                    m.invoke(t, parse);
                }
            }
        }
        return t;
    }

    public JsonObject parseObject(String text) {
        Stack<Object> stacks = new Stack<Object>();
        String status = "BEGIN";
        char[] chars = text.toCharArray();
        if (chars.length > 0) {
            if ('{' != chars[0]) {
                throw new RuntimeException("The structure of jsonString is wrong ");
            }
            block9: for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '{': {
                        status = "KEY";
                        JsonObject jo = new JsonObject();
                        stacks.push(jo);
                        continue block9;
                    }
                    case '}': {
                        this.groupJsonObject(stacks, status);
                        continue block9;
                    }
                    case '\"': {
                        if ("KEY".equals(status)) {
                            this.pushNewString(stacks);
                            continue block9;
                        }
                        if (!"VALUE".equals(status)) continue block9;
                        this.pushNewString(stacks);
                        status = "READINGSTRING";
                        continue block9;
                    }
                    case ':': {
                        if (!status.equals("READINGSTRING")) {
                            status = "VALUE";
                            continue block9;
                        }
                        this.readValue(stacks, chars, i);
                        continue block9;
                    }
                    case ',': {
                        this.groupJsonObject(stacks, status);
                        if (JsonArray.class == stacks.peek().getClass()) {
                            if (i + 1 < chars.length) {
                                char c = chars[i + 1];
                                if (c != '\"') {
                                    status = "VALUE";
                                    continue block9;
                                }
                                status = "KEY";
                                continue block9;
                            }
                            throw new RuntimeException("The structure of jsonString is wrong ");
                        }
                        status = "KEY";
                        continue block9;
                    }
                    case '[': {
                        JsonArray jsonArray = new JsonArray();
                        stacks.push(jsonArray);
                        continue block9;
                    }
                    case ']': {
                        if (JsonObject.class == stacks.peek().getClass()) {
                            JsonObject jsonObject = (JsonObject)stacks.pop();
                            if (JsonArray.class != stacks.peek().getClass()) continue block9;
                            JsonArray jsonArray = (JsonArray)stacks.pop();
                            jsonArray.add(jsonObject);
                            stacks.push(jsonArray);
                            continue block9;
                        }
                        if (StringBuffer.class != stacks.peek().getClass()) continue block9;
                        StringBuffer value = (StringBuffer)stacks.pop();
                        String s = value.toString();
                        if (JsonArray.class != stacks.peek().getClass()) continue block9;
                        JsonArray jsonArray = (JsonArray)stacks.pop();
                        this.addValueForJsonArray(jsonArray, s);
                        stacks.push(jsonArray);
                        continue block9;
                    }
                    default: {
                        if ("VALUE".equals(status)) {
                            this.pushNewString(stacks);
                        }
                        if (!"READINGSTRING".equals(status)) {
                            status = "READING";
                        }
                        this.readValue(stacks, chars, i);
                    }
                }
            }
        }
        if (stacks.size() != 1) {
            throw new RuntimeException("The structure of jsonString is wrong ");
        }
        return (JsonObject)stacks.pop();
    }

    private void readValue(Stack stacks, char[] chars, int i) {
        StringBuffer sb = (StringBuffer)stacks.pop();
        sb.append(chars[i]);
        stacks.push(sb);
    }

    private void pushNewString(Stack stacks) {
        StringBuffer sb = new StringBuffer();
        stacks.push(sb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void groupJsonObject(Stack<Object> stacks, String status) {
        if (StringBuffer.class == stacks.peek().getClass()) {
            StringBuffer value = (StringBuffer)stacks.pop();
            if (StringBuffer.class == stacks.peek().getClass()) {
                StringBuffer key = (StringBuffer)stacks.pop();
                if (JsonObject.class != stacks.peek().getClass()) throw new RuntimeException("The structure of jsonString is wrong ");
                JsonObject jsonObject = (JsonObject)stacks.pop();
                String s = value.toString();
                if ("READINGSTRING".equals(status)) {
                    jsonObject.put(key.toString(), s);
                    status = "READING";
                } else if (StringUtils.isNumeric(s)) {
                    if (StringUtils.isIntegerNumeric(s)) {
                        jsonObject.put(key.toString(), new Integer(s));
                    } else {
                        jsonObject.put(key.toString(), new BigDecimal(s));
                    }
                } else {
                    boolean b = this.judgeBoolean(s);
                    if (b) {
                        jsonObject.put(key.toString(), new Boolean(s));
                    } else {
                        jsonObject.put(key.toString(), s);
                    }
                }
                stacks.push(jsonObject);
                return;
            } else {
                if (JsonArray.class != stacks.peek().getClass()) throw new RuntimeException("The structure of jsonString is wrong ");
                JsonArray jsonArray = (JsonArray)stacks.pop();
                String s = value.toString();
                this.addValueForJsonArray(jsonArray, s);
                stacks.push(jsonArray);
            }
            return;
        } else if (JsonObject.class == stacks.peek().getClass()) {
            JsonObject value = (JsonObject)stacks.pop();
            if (stacks.isEmpty()) {
                stacks.push(value);
                return;
            } else if (StringBuffer.class == stacks.peek().getClass()) {
                StringBuffer key = (StringBuffer)stacks.pop();
                this.groupJsonObject(stacks, key, value);
                return;
            } else {
                if (JsonArray.class != stacks.peek().getClass()) throw new RuntimeException("The structure of jsonString is wrong ");
                JsonArray array = (JsonArray)stacks.pop();
                array.add(value);
                stacks.push(array);
            }
            return;
        } else {
            if (JsonArray.class != stacks.peek().getClass()) return;
            JsonArray value = (JsonArray)stacks.pop();
            if (StringBuffer.class != stacks.peek().getClass()) return;
            StringBuffer key = (StringBuffer)stacks.pop();
            this.groupJsonObject(stacks, key, value);
        }
    }

    private void groupJsonObject(Stack<Object> stacks, Object key, Object value) {
        if (JsonObject.class != stacks.peek().getClass()) {
            throw new RuntimeException("The structure of jsonString is wrong ");
        }
        JsonObject jsonObject = (JsonObject)stacks.pop();
        jsonObject.put(key.toString(), value);
        stacks.push(jsonObject);
    }

    private void addValueForJsonArray(JsonArray<Object> jsonArray, String object) {
        if (StringUtils.isNumeric(object)) {
            if (StringUtils.isIntegerNumeric(object)) {
                jsonArray.add(new Integer(object));
            } else {
                jsonArray.add(new BigDecimal(object));
            }
        } else {
            jsonArray.add(object);
        }
    }

    private boolean judgeBoolean(String s) {
        return StringUtils.isBoolean(s);
    }
}

