/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.json.codec;

import cn.xxywithpq.json.AbstractJson;
import cn.xxywithpq.json.IJson;
import cn.xxywithpq.json.JsonException;
import cn.xxywithpq.json.JsonObject;
import cn.xxywithpq.json.serializer.JsonSerializer;
import cn.xxywithpq.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Logger;

public class ObjectCodec
extends AbstractJson
implements IJson {
    private static Logger logger = Logger.getLogger(JsonSerializer.class.getName());
    StringJoiner sj;

    private String serializerObject(Object o) {
        this.sj = new StringJoiner(",", "{", "}");
        Class<?> cClass = o.getClass();
        List<Method> allDeclaredMethods = ReflectionUtils.getAllDeclaredMethods(cClass);
        ArrayList<Method> publicGetMethods = new ArrayList<Method>();
        if (null != allDeclaredMethods && allDeclaredMethods.size() > 0) {
            for (Method m : allDeclaredMethods) {
                String modifier = ReflectionUtils.getModifier(m);
                if (!modifier.contains("public") || !m.getName().startsWith("get") && !m.getName().startsWith("is")) continue;
                publicGetMethods.add(m);
            }
        }
        if (null != publicGetMethods && publicGetMethods.size() > 0) {
            Collections.sort(publicGetMethods, (x, y) -> Collator.getInstance().compare(x.getName().startsWith("is") ? x.getName().replace("is", "get") : x.getName(), y.getName().startsWith("is") ? y.getName().replace("is", "get") : y.getName()));
            for (Method method : publicGetMethods) {
                String name = method.getName();
                String substring = name.startsWith("is") ? name.substring(2, name.length()) : name.substring(3, name.length());
                char c = substring.charAt(0);
                if (c < 'A' || c > 'Z') continue;
                Character b = Character.valueOf((char)(c + 32));
                String key = b.toString().concat(substring.substring(1, substring.length()));
                try {
                    Object invoke = method.invoke(o, new Object[0]);
                    if (!Objects.nonNull(invoke)) continue;
                    this.sj.add("\"" + key + "\"" + ":" + JsonSerializer.getInstance().convertToJsonString(invoke));
                }
                catch (IllegalAccessException e) {
                    logger.severe(e.getMessage());
                    throw new JsonException("serializerObject fail", e);
                }
                catch (InvocationTargetException e) {
                    logger.severe(e.getMessage());
                    throw new JsonException("serializerObject fail", e);
                }
            }
        }
        return this.sj.toString();
    }

    @Override
    public Object writeJsonString(Object o) {
        String result = this.serializerObject(o);
        return result;
    }

    @Override
    public Object parse(Object o, Method m) {
        JsonObject jo = (JsonObject)o;
        Type[] genericParameterTypes = m.getGenericParameterTypes();
        Type t = null;
        for (Type type : genericParameterTypes) {
            if (!ParameterizedType.class.isAssignableFrom(type.getClass())) continue;
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type t1;
                t = t1 = typeArray[i];
            }
        }
        try {
            Class<?> aClass = Objects.isNull(t) ? m.getParameterTypes()[0].getComponentType() : Class.forName(t.getTypeName());
            Object o1 = aClass.newInstance();
            List<Method> allDeclaredMethods = ReflectionUtils.getAllDeclaredMethods(aClass);
            ArrayList<Method> publicSetMethods = new ArrayList<Method>();
            if (null != allDeclaredMethods && allDeclaredMethods.size() > 0) {
                for (Method md : allDeclaredMethods) {
                    String modifier = ReflectionUtils.getModifier(md);
                    if (!modifier.contains("public") || !md.getName().startsWith("set")) continue;
                    publicSetMethods.add(md);
                }
            }
            if (null != publicSetMethods && publicSetMethods.size() > 0) {
                for (Method md : publicSetMethods) {
                    String methodName = md.getName();
                    String variable = methodName.substring(3, methodName.length());
                    Class<?>[] parameterTypes = md.getParameterTypes();
                    Class<?> parameterType = null;
                    if (null != parameterTypes && parameterTypes.length == 1) {
                        parameterType = parameterTypes[0];
                    }
                    if (!jo.containsKey(variable = variable.substring(0, 1).toLowerCase() + variable.substring(1, variable.length()))) continue;
                    Object oo = jo.get(variable);
                    IJson suitableHandler = this.getSuitableHandler(parameterType);
                    Object parse = suitableHandler.parse(oo, md);
                    try {
                        md.invoke(o1, parse);
                    }
                    catch (IllegalAccessException e) {
                        logger.severe(e.getMessage());
                        throw new JsonException("ObjectCodec fail", e);
                    }
                    catch (InvocationTargetException e) {
                        logger.severe(e.getMessage());
                        throw new JsonException("ObjectCodec fail", e);
                    }
                }
            }
            return o1;
        }
        catch (ClassNotFoundException e) {
            logger.severe(e.getMessage());
            throw new JsonException(e);
        }
        catch (IllegalAccessException e) {
            logger.severe(e.getMessage());
            throw new JsonException(e);
        }
        catch (InstantiationException e) {
            logger.severe(e.getMessage());
            throw new JsonException(e);
        }
    }
}

