/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.json.codec;

import cn.xxywithpq.json.AbstractJson;
import cn.xxywithpq.json.IJson;
import cn.xxywithpq.json.JsonException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class NumberCodec
extends AbstractJson
implements IJson {
    StringBuffer sb;

    @Override
    public Object writeJsonString(Object o) {
        Number n = (Number)o;
        this.sb = new StringBuffer(n.toString().length());
        this.numberHandle(this.sb, n);
        return this.sb.toString();
    }

    @Override
    public Object parse(Object o, Method m) {
        Class<?> parameterTypes = this.getParameterTypes(m);
        if (Map.class.isAssignableFrom(parameterTypes)) {
            Type actualTypeArguments = this.getActualTypeArguments(m);
            return this.numberParse(o, (Class)actualTypeArguments);
        }
        return this.numberParse(o, parameterTypes);
    }

    private Object numberParse(Object o, Class parameterTypes) {
        if (parameterTypes == Integer.TYPE || parameterTypes == Integer.class) {
            if (o instanceof Integer) {
                return o;
            }
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).intValue();
            }
            if (o instanceof BigInteger) {
                return ((BigInteger)o).intValue();
            }
            return o;
        }
        if (parameterTypes == Long.TYPE || parameterTypes == Long.class) {
            if (o instanceof Long) {
                return o;
            }
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).longValue();
            }
            if (o instanceof Integer) {
                return ((Integer)o).longValue();
            }
        }
        if (parameterTypes == Short.TYPE || parameterTypes == Short.class) {
            if (o instanceof Short) {
                return o;
            }
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).shortValue();
            }
            if (o instanceof Integer) {
                return ((Integer)o).shortValue();
            }
        }
        if (parameterTypes == Double.TYPE || parameterTypes == Double.class) {
            if (o instanceof Double) {
                return o;
            }
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).doubleValue();
            }
            if (o instanceof Integer) {
                return ((Integer)o).doubleValue();
            }
        }
        if (parameterTypes == Float.TYPE || parameterTypes == Float.class) {
            if (o instanceof Float) {
                return o;
            }
            if (o instanceof BigDecimal) {
                return Float.valueOf(((BigDecimal)o).floatValue());
            }
            if (o instanceof Integer) {
                return Float.valueOf(((Integer)o).floatValue());
            }
        }
        if (parameterTypes == Byte.TYPE || parameterTypes == Byte.class) {
            if (o instanceof Byte) {
                return o;
            }
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).byteValue();
            }
            if (o instanceof Integer) {
                return ((Integer)o).byteValue();
            }
        }
        throw new JsonException("unsupport type " + parameterTypes);
    }
}

