/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.json.codec;

import cn.xxywithpq.json.AbstractJson;
import cn.xxywithpq.json.IJson;
import cn.xxywithpq.json.JsonException;
import cn.xxywithpq.json.JsonObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MapCodec
extends AbstractJson
implements IJson {
    StringJoiner sj;

    @Override
    public Object writeJsonString(Object o) {
        this.sj = new StringJoiner(",", "{", "}");
        Map m = (Map)o;
        this.mapHandle(this.sj, m);
        return this.sj.toString();
    }

    @Override
    public Object parse(Object o, Method m) {
        Class<?> rawType = this.getParameterTypes(m);
        Type t = this.getActualTypeArguments(m);
        Map<Object, Object> p = this.createMap(rawType);
        JsonObject jo = (JsonObject)o;
        Set keys = jo.keySet();
        if (null != jo && jo.size() > 0) {
            for (Object key : keys) {
                Object oo = jo.get(key);
                try {
                    Class<?> aClass = Class.forName(t.getTypeName());
                    IJson suitableHandler = this.getSuitableHandler(aClass);
                    Object parse = suitableHandler.parse(oo, m);
                    p.put(key, parse);
                }
                catch (ClassNotFoundException e) {
                    throw new JsonException("class not found ", e);
                }
            }
        }
        return p;
    }

    private Map<Object, Object> createMap(Type type) {
        if (type == Properties.class) {
            return new Properties();
        }
        if (type == Hashtable.class) {
            return new Hashtable<Object, Object>();
        }
        if (type == IdentityHashMap.class) {
            return new IdentityHashMap<Object, Object>();
        }
        if (type == SortedMap.class || type == TreeMap.class) {
            return new TreeMap<Object, Object>();
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return new ConcurrentHashMap<Object, Object>();
        }
        if (type == Map.class || type == HashMap.class) {
            return new HashMap<Object, Object>();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap<Object, Object>();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (EnumMap.class.equals((Object)rawType)) {
                Type[] actualArgs = parameterizedType.getActualTypeArguments();
                return new EnumMap<Object, Object>((Class)actualArgs[0]);
            }
            return this.createMap(rawType);
        }
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            throw new JsonException("unsupport type " + type);
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JsonException("unsupport type " + type, e);
        }
    }
}

