/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.json.codec;

import cn.xxywithpq.json.AbstractJson;
import cn.xxywithpq.json.IJson;
import cn.xxywithpq.json.JsonException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeSet;

public class CollectionCodec
extends AbstractJson
implements IJson {
    StringJoiner sj;

    @Override
    public Object writeJsonString(Object o) {
        this.sj = new StringJoiner(",", "[", "]");
        Collection c = (Collection)o;
        this.collectionHandle(this.sj, c);
        return this.sj.toString();
    }

    @Override
    public Object parse(Object o, Method m) {
        ArrayList al = (ArrayList)o;
        Type t = this.getActualTypeArguments(m);
        Class<?> rawClass = this.getParameterTypes(m);
        Collection collection = CollectionCodec.createCollection(rawClass);
        if (Objects.nonNull(t)) {
            ListIterator listIterator = al.listIterator();
            IJson suitableParseHandler = this.getSuitableHandler(t.getClass());
            while (listIterator.hasNext()) {
                Object next = listIterator.next();
                Object parse = suitableParseHandler.parse(next, m);
                collection.add(parse);
            }
        } else {
            collection.addAll(al);
        }
        return collection;
    }

    private static Collection createCollection(Class rawClass) {
        Collection<Object> list;
        Type type = rawClass.getGenericSuperclass();
        if (rawClass == AbstractCollection.class || rawClass == Collection.class) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (rawClass.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (rawClass.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (rawClass.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(EnumSet.class)) {
            Object itemType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
            list = EnumSet.noneOf(itemType);
        } else {
            try {
                list = (Collection)rawClass.newInstance();
            }
            catch (Exception e) {
                throw new JsonException("create instance error, class " + rawClass.getName());
            }
        }
        return list;
    }
}

