/*
 * Decompiled with CFR 0.152.
 */
package cn.xxywithpq.json;

import cn.xxywithpq.SimpleDate;
import cn.xxywithpq.date.ext.DateTimeFormatterExt;
import cn.xxywithpq.json.IJson;
import cn.xxywithpq.json.codec.ArrayCodec;
import cn.xxywithpq.json.codec.BooleanCodec;
import cn.xxywithpq.json.codec.CharCodec;
import cn.xxywithpq.json.codec.CollectionCodec;
import cn.xxywithpq.json.codec.DateCodec;
import cn.xxywithpq.json.codec.MapCodec;
import cn.xxywithpq.json.codec.NumberCodec;
import cn.xxywithpq.json.codec.ObjectCodec;
import cn.xxywithpq.json.codec.StringCodec;
import cn.xxywithpq.json.codec.TemporalCodec;
import cn.xxywithpq.json.serializer.JsonSerializer;
import cn.xxywithpq.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public abstract class AbstractJson {
    private JsonSerializer jsonSerializer = JsonSerializer.getInstance();

    protected void characterHandle(StringBuffer sb, CharSequence cs) {
        sb.append("\"").append(cs).append("\"");
    }

    protected void characterHandle(StringBuffer sb, Character cs) {
        sb.append("\"").append(cs.charValue()).append("\"");
    }

    protected void numberHandle(StringBuffer sb, Number cs) {
        sb.append(cs);
    }

    protected void collectionHandle(StringJoiner sj, Collection cs) {
        Iterator iterator = cs.iterator();
        while (iterator.hasNext()) {
            sj.add(this.jsonSerializer.convertToJsonString(iterator.next()));
        }
    }

    protected void mapHandle(StringJoiner sj, Map cs) {
        Set set = cs.keySet();
        for (Object next : set) {
            sj.add("\"" + next + "\"" + ":" + this.jsonSerializer.convertToJsonString(cs.get(next)));
        }
    }

    protected void dateHandle(StringBuffer sb, Date d) {
        sb.append(d.getTime());
    }

    protected void localDateHandle(StringBuffer sb, LocalDate ld) {
        sb.append("\"" + SimpleDate.dateToString(ld, "yyyy-MM-dd") + "\"");
    }

    protected void localDateTimeHandle(StringBuffer sb, LocalDateTime ldt) {
        DateTimeFormatter isoLocalDateTime = DateTimeFormatterExt.ISO_LOCAL_DATE_TIME;
        sb.append("\"" + isoLocalDateTime.format(ldt) + "\"");
    }

    protected void localTimeHandle(StringBuffer sb, LocalTime lt) {
        DateTimeFormatter isoTime = DateTimeFormatterExt.ISO_LOCAL_TIME;
        sb.append("\"" + isoTime.format(lt) + "\"");
    }

    protected IJson getSuitableHandler(Class c) {
        if (Collection.class.isAssignableFrom(c)) {
            return new CollectionCodec();
        }
        if (Map.class.isAssignableFrom(c)) {
            return new MapCodec();
        }
        if (Number.class.isAssignableFrom(c)) {
            return new NumberCodec();
        }
        if (c.isArray()) {
            return new ArrayCodec();
        }
        if (Temporal.class.isAssignableFrom(c)) {
            return new TemporalCodec();
        }
        if (c == Character.TYPE || c == Character.class) {
            return new CharCodec();
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return new BooleanCodec();
        }
        if (c == String.class) {
            return new StringCodec();
        }
        if (c == Date.class) {
            return new DateCodec();
        }
        return new ObjectCodec();
    }

    protected Type getActualTypeArguments(Method m) {
        int n = 0;
        Type[] genericParameterTypes = m.getGenericParameterTypes();
        Type[] typeArray = genericParameterTypes;
        int n2 = typeArray.length;
        if (n < n2) {
            Type type = typeArray[n];
            Type[] actualTypeArguments = ReflectionUtils.getActualTypeArguments(type);
            if (null == actualTypeArguments || actualTypeArguments.length == 0) {
                return null;
            }
            if (actualTypeArguments.length > 1) {
                return actualTypeArguments[1];
            }
            return actualTypeArguments[0];
        }
        return null;
    }

    protected Class<?> getParameterTypes(Method m) {
        Class<?>[] parameterTypes = m.getParameterTypes();
        return parameterTypes[0];
    }
}

