package cn.xx996.wxsdk.webchat;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.xx996.wxsdk.parameter.QRParams;
import com.alibaba.fastjson.JSON;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lzz
 */
@SuppressWarnings("all")
public class QRCode {


    /**
     * 获取小程序二维码，适用于需要的码数量较少的业务场景。通过该接口生成的小程序码，永久有效，有数量限制
     *
     * @param qrParams
     * @param savePath 保存地址 D:\\a.png
     * @return
     * @throws IOException
     */
    public static String createQRCode(QRParams qrParams, String savePath) throws IOException {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=%s", qrParams.getAccessToken());
        Map<String, Object> map = new HashMap<>();
        map.put("path", qrParams.getPath());
        map.put("width", qrParams.getWidth());
        String responseMess = createQR(savePath, url, map);
        if (responseMess != null) {
            return responseMess;
        }
        return savePath;
    }

    /**
     * 获取小程序二维码，适用于需要的码数量较少的业务场景。通过该接口生成的小程序码，永久有效，有数量限制
     *
     * @param qrParams
     * @return
     * @throws IOException
     */
    public static byte[] createQRCode(QRParams qrParams) throws IOException {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=%s", qrParams.getAccessToken());
        Map<String, Object> map = new HashMap<>();
        map.put("path", qrParams.getPath());
        map.put("width", qrParams.getWidth());
        return createQR(url, map);

    }

    /**
     * 获取小程序码，适用于需要的码数量极多的业务场景。通过该接口生成的小程序码，永久有效，数量暂无限制
     *
     * @param qrParams
     * @param savePath 保存地址 D:\\a.png
     * @return
     * @throws IOException
     */
    public static String getUnlimited(QRParams qrParams, String savePath) throws IOException {

        String url = String.format("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=%s", qrParams.getAccessToken());

        Map<String, Object> map = new HashMap<>();
        map.put("scene", qrParams.getScene());
        map.put("path", qrParams.getPath());
        map.put("width", qrParams.getWidth());
        map.put("auto_color", qrParams.isAutoColor());
        map.put("line_color", qrParams.getLineColor());
        map.put("is_hyaline", qrParams.isHyaline());
        String responseMess = createQR(savePath, url, map);
        if (responseMess != null) {
            return responseMess;
        }
        return savePath;

    }

    /**
     * 获取小程序码，适用于需要的码数量极多的业务场景。通过该接口生成的小程序码，永久有效，数量暂无限制
     *
     * @param qrParams
     * @return
     * @throws IOException
     */
    public static byte[] getUnlimited(QRParams qrParams) {

        String url = String.format("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=%s", qrParams.getAccessToken());

        Map<String, Object> map = new HashMap<>();
        map.put("scene", qrParams.getScene());
        map.put("path", qrParams.getPath());
        map.put("width", qrParams.getWidth());
        map.put("auto_color", qrParams.isAutoColor());
        map.put("line_color", qrParams.getLineColor());
        map.put("is_hyaline", qrParams.isHyaline());
        return createQR(url, map);


    }

    /**
     * 获取小程序码，适用于需要的码数量较少的业务场景。通过该接口生成的小程序码，永久有效，有数量限制
     *
     * @param qrParams
     * @param savePath 保存地址
     * @return
     * @throws IOException
     */
    public static String get(QRParams qrParams, String savePath) throws IOException {
        String url = String.format("https://api.weixin.qq.com/wxa/getwxacode?access_token=%s", qrParams.getAccessToken());

        Map<String, Object> map = new HashMap<>();
        map.put("path", qrParams.getPath());
        map.put("width", qrParams.getWidth());
        map.put("auto_color", qrParams.isAutoColor());
        map.put("line_color", qrParams.getLineColor());
        map.put("is_hyaline", qrParams.isHyaline());
        String responseMess = createQR(savePath, url, map);
        if (responseMess != null) {
            return responseMess;
        }
        return savePath;

    }

    /**
     * 获取小程序码，适用于需要的码数量较少的业务场景。通过该接口生成的小程序码，永久有效，有数量限制
     *
     * @param qrParams
     * @return
     */
    public static byte[] get(QRParams qrParams) {
        String url = String.format("https://api.weixin.qq.com/wxa/getwxacode?access_token=%s", qrParams.getAccessToken());

        Map<String, Object> map = new HashMap<>();
        map.put("path", qrParams.getPath());
        map.put("width", qrParams.getWidth());
        map.put("auto_color", qrParams.isAutoColor());
        map.put("line_color", qrParams.getLineColor());
        map.put("is_hyaline", qrParams.isHyaline());
        return createQR(url, map);


    }

    private static byte[] createQR(String url, Map<String, Object> map) {
        HttpRequest httpRequest = HttpRequest.post(url).body(JSON.toJSONBytes(map));

        return httpRequest.execute().bodyBytes();


    }

    private static String createQR(String savePath, String url, Map<String, Object> map) throws IOException {
        HttpRequest httpRequest = HttpRequest.post(url).body(JSON.toJSONBytes(map));
        File imageFile = new File(savePath);
        HttpResponse responseMess = httpRequest.execute();
        if (responseMess.body().indexOf("error") != -1) {
            return responseMess.body();
        }
        FileOutputStream outStream = new FileOutputStream(imageFile);
        outStream.write(responseMess.bodyBytes());
        outStream.close();
        return null;
    }
}
