package cn.xx996.wxsdk.webchat;

import cn.hutool.http.HttpUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @BelongsProject: wx-sdk
 * @BelongsPackage: cn.xx996.wxsdk.webchat
 * @Author: lizeze
 * @CreateTime: 2021-08-17 22:25
 */
public class Auth {


    /**
     * 登录凭证校验。通过 wx.login 接口获得临时登录凭证 code 后传到开发者服务器调用此接口完成登录流程
     *
     * @param code   登录时获取的 code
     * @param appId
     * @param secret
     * @return
     */
    public static String code2Session(String code, String appId, String secret) {

        String url = String.format("https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code", appId, secret, code);
        return HttpUtil.get(url);
    }


    /**
     * 获取小程序全局唯一后台接口调用凭据（access_token）
     *
     * @param appId
     * @param secret
     * @return
     */
    public static String getAccessToken(String appId, String secret) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", appId, secret);

        return HttpUtil.get(url);

    }

    /**
     * 检查加密信息是否由微信生成（当前只支持手机号加密数据），只能检测最近3天生成的加密数据
     *
     * @param str         加密数据的sha256，通过Hex（Base16）编码后的字符串
     * @param accessToken 调用凭据
     * @return
     */
    public static String checkEncryptedData(String str, String accessToken) {
        String url = String.format("https://api.weixin.qq.com/wxa/business/checkencryptedmsg?access_token=%s", accessToken);
        Map<String, Object> map = new HashMap<>();
        map.put("encrypted_msg_hash", str);
        return HttpUtil.post(url, map);
    }


    /**
     * 用户支付完成后，获取该用户的 UnionId，无需用户授权 注意：调用前需要用户完成支付，且在支付后的五分钟内有效。
     * @param openId
     * @param transactionId 微信支付订单号
     * @param accessToken 调用凭据
     * @return
     */
    public static String getPaidUnionId(String openId, String transactionId, String accessToken) {
        String url = String.format("https://api.weixin.qq.com/wxa/getpaidunionid?access_token=%s&openid=%s&transaction_id=%s", accessToken, openId, transactionId);
        return HttpUtil.get(url);
    }

    /**
     * 用户支付完成后，获取该用户的 UnionId，无需用户授权 注意：调用前需要用户完成支付，且在支付后的五分钟内有效。
     * @param openId
     * @param outTradeNo 微信支付商户订单号
     * @param mchId 微信支付商户号
     * @param accessToken
     * @return
     */
    public static String getPaidUnionId(String openId, String outTradeNo, String mchId, String accessToken) {

        return HttpUtil.get(String.format(" https://api.weixin.qq.com/wxa/getpaidunionid?access_token=%s&openid=%s&mch_id=%s&out_trade_no=%s", accessToken, openId, mchId, outTradeNo));
    }

}
